/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    private static ColorSpace cmykCS;
    private static ColorSpace rgbCS;
    private static ColorConvertOp CSToRGB;
    private static ColorModel rgbModel;

    private static void initCMYKColorspace() throws PdfException {
        try {
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jpedal/res/cmm/cmyk.icm"));
            ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
            ICC_Profile iCC_Profile2 = ICC_Profile.getInstance(1000);
            rgbCS = new ICC_ColorSpace(iCC_Profile2);
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            CSToRGB = new ColorConvertOp(iCC_ColorSpace, rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public static BufferedImage convertFromICCCMYK(int n, int n2, byte[] byArray, ColorSpace colorSpace) {
        if (colorSpace == null) {
            colorSpace = rgbCS;
        }
        BufferedImage bufferedImage = null;
        try {
            Object object;
            int n3 = n * n2 * 4;
            if (byArray.length < n3) {
                object = new byte[n3];
                System.arraycopy(byArray, 0, object, 0, byArray.length);
                byArray = object;
            }
            object = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n * 4, 4, nArray, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
        }
        return bufferedImage;
    }

    public static BufferedImage convertFromICCCMYK(int n, int n2, DataBuffer dataBuffer, ColorSpace colorSpace) {
        BufferedImage bufferedImage = null;
        try {
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n, n2, n * 4, 4, nArray, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
        }
        return bufferedImage;
    }

    public static byte[] convertIndexToRGB(byte[] byArray, ColorSpace colorSpace) {
        if (colorSpace == null) {
            colorSpace = cmykCS;
        }
        try {
            int n = byArray.length / 4;
            int n2 = 1;
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
            WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n, n2);
            if (CSToRGB == null) {
                ColorSpaceConvertor.initCMYKColorspace();
            }
            CSToRGB.filter(writableRaster, writableRaster2);
            int n3 = n * n2 * 3;
            byArray = new byte[n3];
            DataBuffer dataBuffer = writableRaster2.getDataBuffer();
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)dataBuffer.getElem(i);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray;
    }

    public static final BufferedImage convertToRGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 1) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpaces.hints);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " removing alpha from JPEG image");
            }
        }
        return bufferedImage;
    }

    public static final BufferedImage convertToARGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 2) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " creating argb image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        byte[] byArray2 = new byte[n * n2 * 3];
        int n3 = n * n2 * 4;
        double d = -1.0;
        double d2 = -1.12;
        double d3 = -1.12;
        double d4 = -1.21;
        double d5 = 255.0;
        byArray2 = new byte[n * n2 * 3];
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        for (int i = 0; i < n3; i += 4) {
            double d9 = (double)(byArray[i] & 0xFF) / d5;
            double d10 = (double)(byArray[i + 1] & 0xFF) / d5;
            double d11 = (double)(byArray[i + 2] & 0xFF) / d5;
            double d12 = (double)(byArray[i + 3] & 0xFF) / d5;
            if (d != d9 || d2 != d10 || d3 != d11 || d4 != d12) {
                double d13 = 1.0;
                double d14 = ColorSpaceConvertor.clip01(d9 + d12);
                double d15 = ColorSpaceConvertor.clip01(d10 + d12);
                double d16 = ColorSpaceConvertor.clip01(d11 + d12);
                double d17 = (d13 - d14) * (d13 - d15) * (d13 - d16);
                double d18 = d14 * (d13 - d15) * (d13 - d16);
                double d19 = (d13 - d14) * d15 * (d13 - d16);
                double d20 = (d13 - d14) * (d13 - d15) * d16;
                double d21 = (d13 - d14) * d15 * d16;
                double d22 = d14 * (d13 - d15) * d16;
                double d23 = d14 * d15 * (d13 - d16);
                d6 = d5 * ColorSpaceConvertor.clip01(d17 + 0.9137 * d19 + 0.9961 * d20 + 0.9882 * d21);
                d7 = d5 * ColorSpaceConvertor.clip01(d17 + 0.6196 * d18 + d20 + 0.5176 * d22);
                d8 = d5 * ColorSpaceConvertor.clip01(d17 + 0.7804 * d18 + 0.5412 * d19 + 0.0667 * d21 + 0.2118 * d22 + 0.4863 * d23);
                d = d9;
                d2 = d10;
                d3 = d11;
                d4 = d12;
            }
            byArray2[n4++] = (byte)d6;
            byArray2[n4++] = (byte)d7;
            byArray2[n4++] = (byte)d8;
        }
        try {
            int[] nArray = new int[]{0, 1, 2};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
        }
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(DataBuffer dataBuffer, int n, int n2, boolean bl) {
        BufferedImage bufferedImage = null;
        byte[] byArray = new byte[n * n2 * 3];
        int n3 = n * n2 * 4;
        byArray = new byte[n * n2 * 3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = -1.0;
        double d2 = -1.12;
        double d3 = -1.12;
        double d4 = -1.21;
        int n7 = 0;
        for (int i = 0; i < n3; i += 4) {
            double d5 = dataBuffer.getElemDouble(i);
            double d6 = dataBuffer.getElemDouble(1 + i);
            double d7 = dataBuffer.getElemDouble(2 + i);
            double d8 = dataBuffer.getElemDouble(3 + i);
            if (d != d5 || d2 != d6 || d3 != d7 || d4 != d8) {
                double d9 = d5;
                if (bl) {
                    System.out.println(d5 + " " + d6 + " " + d7 + " " + d8);
                }
                n4 = ColorSpaceConvertor.checkRange(d5 - d8 + 1.402 * (d7 - 128.0));
                n5 = ColorSpaceConvertor.checkRange(d5 - d8 - 0.34414 * (d6 - 128.0) - 0.71414 * (d7 - 128.0));
                n6 = ColorSpaceConvertor.checkRange(d5 - d8 + 1.772 * (d6 - 128.0));
                if (d5 == 255.0 && d7 == d6) {
                    n4 = 255;
                    n5 = 255;
                    n6 = 255;
                }
                if (bl) {
                    System.out.println(n4 + " " + n5 + " " + n6);
                }
                d = d5;
                d2 = d6;
                d3 = d7;
                d4 = d8;
            }
            byArray[n7++] = (byte)n4;
            byArray[n7++] = (byte)n5;
            byArray[n7++] = (byte)n6;
        }
        try {
            int[] nArray = new int[]{0, 1, 2};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
        }
        return bufferedImage;
    }

    public static final BufferedImage convertColorspace(BufferedImage bufferedImage, int n) {
        try {
            BufferedImage bufferedImage2 = bufferedImage;
            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), n);
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(bufferedImage2, bufferedImage);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " converting image");
        }
        return bufferedImage;
    }

    private static int checkRange(double d) {
        int n = (int)d;
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    private static double clip01(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    static {
        CSToRGB = null;
        rgbModel = null;
    }
}

