/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.Function;
import org.jpedal.io.PdfObjectReader;

class Stitching
extends Function {
    Function[] funs_;
    float[] bounds_;
    float[] encode_;
    int n_;

    Stitching(Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        this.range = fArray2;
        this.domain = fArray;
        String string = pdfObjectReader.getValue((String)map.get("Bounds"));
        string = pdfObjectReader.getValue((String)map.get("Bounds"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        this.bounds_ = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.bounds_[n] = Float.parseFloat(stringTokenizer.nextToken());
            ++n;
        }
        string = pdfObjectReader.getValue((String)map.get("Encode"));
        stringTokenizer = new StringTokenizer(string, "[] ");
        this.encode_ = new float[stringTokenizer.countTokens()];
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.encode_[n] = Float.parseFloat(stringTokenizer.nextToken());
            ++n;
        }
    }

    public int getN() {
        return this.n_;
    }

    public final String[] compute(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        try {
            this.compute(fArray, fArray2);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + fArray2[n - i - 1];
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return stringArray;
    }

    public void compute(float[] fArray, float[] fArray2) {
        int n;
        this.clip(fArray, this.domain);
        float f = fArray[0];
        for (n = this.bounds_.length - 1; n >= 0 && !(f >= this.bounds_[n]); --n) {
        }
        float[] fArray3 = new float[1];
        float f2 = ++n > 0 ? this.bounds_[n - 1] : this.domain[0];
        float f3 = n < this.bounds_.length ? this.bounds_[n] : this.domain[1];
        float f4 = this.encode_[n * 2];
        float f5 = this.encode_[n * 2 + 1];
        fArray3[0] = f4 + (f - f2) * (f5 - f4) / (f3 - f2);
        this.funs_[n].compute(fArray3, fArray2);
        if (this.range != null) {
            this.clip(fArray2, this.range);
        }
    }
}

