/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;

public class StandardFonts {
    private static Map unicode_name_mapping_table = new Hashtable();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE1 = 1;
    public static final int TRUETYPE = 2;
    public static final int TYPE3 = 3;
    public static final int CIDTYPE0 = 4;
    public static final int CIDTYPE2 = 5;
    private static final String enc = "Cp1252";
    private static Map[] glyphToChar = new Hashtable[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static ClassLoader loader;
    private static Hashtable standardFileList;
    private static Hashtable standardFontLoaded;
    private static Map widthTableStandard;
    private static String[] CIDFonts;
    protected static Map javaFontList;
    protected static final String[] javaFonts;
    protected static final String[] files_names;
    protected static final String[] files_names_bis;
    private static Hashtable adobeMap;
    static /* synthetic */ Class class$org$jpedal$fonts$StandardFonts;

    public static String getUnicodeName(String string) {
        return (String)unicode_name_mapping_table.get(string);
    }

    public static String getUnicodeChar(int n, int n2) {
        return unicode_char_decoding_table[n][n2];
    }

    public static Float getStandardWidth(String string, String string2) {
        String string3;
        int n;
        Object v = widthTableStandard.get(string + string2);
        if (v == null && (n = (string3 = string).indexOf(",")) != -1) {
            string3 = string3.substring(0, n);
            v = widthTableStandard.get(string3 + string2);
        }
        return (Float)v;
    }

    private static final void readStandardMappingTable(int n, String string) {
        String string2 = null;
        int n2 = 0;
        BufferedReader bufferedReader = null;
        StandardFonts.glyphToChar[n] = new Hashtable();
        try {
            BufferedReader bufferedReader2 = bufferedReader = string.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), enc)) : new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), "UTF-16"));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open " + string + " to read standard encoding");
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                String string5;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (string2.indexOf("space") != -1 || stringTokenizer.countTokens() <= 1) continue;
                if (stringTokenizer.countTokens() == 3) {
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                } else {
                    string4 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string5 = "" + (char)Integer.parseInt(string3);
                }
                unicode_name_mapping_table.put(n + string4, string5);
                glyphToChar[n].put(string4, new Integer(Integer.parseInt(string3)));
                if (string.equals("zapf.cfg")) {
                    unicode_name_mapping_table.put(string4, string5);
                }
                if (!Character.isDigit(string3.charAt(0))) continue;
                n2 = Integer.parseInt(string3, 8);
                if (n == 5) {
                    StandardFonts.ZAPF_char_encoding_table[n2] = string5;
                } else if (n == 4) {
                    StandardFonts.SYMBOL_char_encoding_table[n2] = string5;
                } else if (n == 3) {
                    StandardFonts.MACEXPERT_char_encoding_table[n2] = string5;
                }
                StandardFonts.unicode_char_decoding_table[n][n2] = string4;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
        }
    }

    private static final void readStandardMappingTable(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            StandardFonts.glyphToChar[n] = new Hashtable();
            glyphToChar[n].put("space", new Integer(32));
            bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), enc));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
            }
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.indexOf("space") != -1) {
                    string2 = " ";
                    if (n == 0) {
                        StandardFonts.MAC_char_encoding_table[32] = string2;
                        StandardFonts.unicode_char_decoding_table[0][32] = "space";
                    } else if (n == 1) {
                        StandardFonts.STD_char_encoding_table[32] = string2;
                        StandardFonts.unicode_char_decoding_table[1][32] = "space";
                    } else if (n == 6) {
                        StandardFonts.PDF_char_encoding_table[32] = string2;
                        StandardFonts.unicode_char_decoding_table[6][32] = "space";
                    } else if (n == 2) {
                        StandardFonts.WIN_char_encoding_table[32] = string2;
                        StandardFonts.unicode_char_decoding_table[2][32] = "space";
                    }
                    unicode_name_mapping_table.put("space", string2);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                unicode_name_mapping_table.put(string3, string2);
                if (n == 0 && Character.isDigit(string5.charAt(0))) {
                    n2 = Integer.parseInt(string5, 8);
                    StandardFonts.MAC_char_encoding_table[n2] = string2;
                    StandardFonts.unicode_char_decoding_table[0][n2] = string3;
                    glyphToChar[0].put(string3, new Integer(n2));
                    continue;
                }
                if (n == 1 && Character.isDigit(string4.charAt(0))) {
                    n4 = Integer.parseInt(string4, 8);
                    StandardFonts.STD_char_encoding_table[n4] = string2;
                    StandardFonts.unicode_char_decoding_table[1][n4] = string3;
                    glyphToChar[1].put(string3, new Integer(n4));
                    continue;
                }
                if (n == 6 && Character.isDigit(string7.charAt(0))) {
                    n4 = Integer.parseInt(string7, 8);
                    StandardFonts.PDF_char_encoding_table[n4] = string2;
                    StandardFonts.unicode_char_decoding_table[6][n4] = string3;
                    continue;
                }
                if (n != 2 || !Character.isDigit(string6.charAt(0))) continue;
                n3 = Integer.parseInt(string6, 8);
                StandardFonts.WIN_char_encoding_table[n3] = string2;
                StandardFonts.unicode_char_decoding_table[2][n3] = string3;
                glyphToChar[2].put(string3, new Integer(n3));
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for " + n);
        }
    }

    public static String getEncodedChar(int n, int n2) {
        String string = null;
        if (n == 2) {
            string = WIN_char_encoding_table[n2];
        } else if (n == 1) {
            string = STD_char_encoding_table[n2];
        } else if (n == 0) {
            string = MAC_char_encoding_table[n2];
        } else if (n == 6) {
            string = PDF_char_encoding_table[n2];
        } else if (n == 5) {
            string = ZAPF_char_encoding_table[n2];
        } else if (n == 4) {
            string = SYMBOL_char_encoding_table[n2];
        } else if (n == 3) {
            string = MACEXPERT_char_encoding_table[n2];
        }
        if (string == null) {
            string = "&#" + n2 + ";";
        }
        return string;
    }

    public static boolean isValidMacEncoding(int n) {
        return MAC_char_encoding_table[n] != null;
    }

    public static boolean isValidWinEncoding(int n) {
        return WIN_char_encoding_table[n] != null;
    }

    public static void checkLoaded(int n) {
        if (n == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (n == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (n == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    private static final void loadStandardFont(int n) throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        BufferedReader bufferedReader = null;
        float f = 200.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[n] + ".afm"), enc));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer;
            if (string.startsWith("EndCharMetrics")) {
                bl = false;
            }
            if (string.startsWith("FontBBox")) {
                stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                n6 = Integer.parseInt(stringTokenizer.nextToken());
                n7 = Integer.parseInt(stringTokenizer.nextToken());
                n8 = Integer.parseInt(stringTokenizer.nextToken());
                n9 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (bl) {
                stringTokenizer = new StringTokenizer(string, " ;");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("C")) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (string2.equals("WX")) {
                        f = Float.parseFloat(stringTokenizer.nextToken()) / 1000.0f;
                    }
                    if (string2.equals("N")) {
                        string3 = stringTokenizer.nextToken();
                    }
                    if (!string2.equals("B")) continue;
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                }
                widthTableStandard.put(files_names_bis[n] + string3, new Float(f));
                widthTableStandard.put(files_names[n] + string3, new Float(f));
            }
            if (!string.startsWith("StartCharMetrics")) continue;
            bl = true;
        }
    }

    protected static void loadStandardFontWidth(String string) {
        Integer n = (Integer)standardFileList.get(string);
        if (n != null && standardFontLoaded.get(n) == null) {
            standardFontLoaded.put(n, "x");
            try {
                StandardFonts.loadStandardFont(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] " + exception + " problem reading lookup table for pdf font " + string + " " + string);
            }
        }
    }

    public static int lookupCharacterIndex(String string, int n) {
        Object v = glyphToChar[n].get(string);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public static void loadAdobeMap() {
        if (adobeMap == null) {
            try {
                String string;
                adobeMap = new Hashtable();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/glyphlist.cfg"), enc));
                if (bufferedReader == null) {
                    LogWriter.writeLog("Unable to open sglyphlist.cfg from jar");
                }
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#") || string.indexOf(";") == -1) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    adobeMap.put(string2, new Integer(Integer.parseInt(string3, 16)));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static int getAdobeMap(String string) {
        return (Integer)adobeMap.get(string);
    }

    public static boolean isStandardFont(String string) {
        return standardFileList.get(string) != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        loader = (class$org$jpedal$fonts$StandardFonts == null ? (class$org$jpedal$fonts$StandardFonts = StandardFonts.class$("org.jpedal.fonts.StandardFonts")) : class$org$jpedal$fonts$StandardFonts).getClassLoader();
        standardFileList = new Hashtable();
        standardFontLoaded = new Hashtable();
        widthTableStandard = new Hashtable();
        CIDFonts = new String[]{"83pv-RKSJ-H", "90msp-RKSJ-H", "90msp-RKSJ-V", "90ms-RKSJ-H", "90ms-RKSJ-UCS2", "90ms-RKSJ-V", "90pv-RKSJ-H", "90pv-RKSJ-UCS2", "90pv-RKSJ-UCS2C", "Add-RKSJ-H", "Add-RKSJ-V", "Adobe-CNS1-3", "Adobe-CNS1-UCS2", "Adobe-GB1-4", "Adobe-GB1-UCS2", "Adobe-Japan1-4", "Adobe-Japan1-UCS2", "Adobe-Korea1-2", "Adobe-Korea1-UCS2", "B5pc-H", "B5pc-UCS2", "B5pc-UCS2C", "B5pc-V", "CNS-EUC-H", "CNS-EUC-V", "ETen-B5-H", "ETen-B5-UCS2", "ETen-B5-V", "euc-h", "euc-v", "Ext-RKSJ-H", "Ext-RKSJ-V", "gb-euc-h", "gb-euc-v", "gbk2k-h", "gbk2k-v", "GBK-EUC-H", "GBK-EUC-UCS2", "GBK-EUC-V", "GBKp-EUC-H", "GBKp-EUC-V", "GBpc-EUC-H", "GBpc-EUC-UCS2", "GBpc-EUC-UCS2C", "GBpc-EUC-V", "GBT-EUC-H", "GBT-EUC-V", "h", "HKscs-B5-H", "HKscs-B5-V", "KSC-EUC-H", "KSC-EUC-V", "KSCms-UHC-H", "KSCms-UHC-HW-H", "KSCms-UHC-HW-V", "KSCms-UHC-UCS2", "KSCms-UHC-V", "KSCpc-EUC-H", "KSCpc-EUC-UCS2", "KSCpc-EUC-UCS2C", "UniCNS-UCS2-H", "UniCNS-UCS2-V", "UniGB-UCS2-H", "UniGB-UCS2-V", "UniJIS-UCS2-H", "UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-V", "UniJIS-UCS2-V", "UniKS-UCS2-H", "UniKS-UCS2-V", "v"};
        javaFontList = new Hashtable();
        javaFonts = new String[]{"Courier", "Courier", "Courier", "Courier", "Arial", "Arial", "Arial", "Arial", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Webdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
        adobeMap = null;
        for (int i = 0; i < files_names.length; ++i) {
            standardFileList.put(files_names_bis[i], new Integer(i));
            standardFileList.put(files_names[i], new Integer(i));
        }
    }
}

