/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.jpaneldemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.jpedal.PdfDecoder;
import org.jpedal.gui.FileFilterer;

public class JPanelDemo
extends JFrame {
    private PdfDecoder pdfDecoder;
    private String currentFile = null;
    private int currentPage = 1;
    private final JLabel pageCounter1 = new JLabel("Page ");
    private JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3 = new JLabel("of");

    public JPanelDemo(String string) {
        this.pdfDecoder = new PdfDecoder();
        this.currentFile = string;
        try {
            this.pdfDecoder.openPdfFile(this.currentFile);
            this.pdfDecoder.decodePage(this.currentPage);
            this.pdfDecoder.setPageParameters(1.0f, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initializeViewer();
        this.pageCounter2.setText(this.currentPage + "");
        this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
    }

    public JPanelDemo() {
        this.pdfDecoder = new PdfDecoder();
        this.selectFile();
        this.initializeViewer();
    }

    private void selectFile() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = 1;
        while (n == 1 || n == -1) {
            n = jFileChooser.showOpenDialog(this);
            if (n == -1) {
                System.err.println("JFileChooser error");
            }
            if (n != 0) continue;
            this.currentFile = jFileChooser.getSelectedFile().getAbsolutePath();
            this.currentPage = 1;
            try {
                this.pdfDecoder.closePdfFile();
                this.pdfDecoder.openPdfFile(this.currentFile);
                if (!this.checkEncryption()) {
                    n = 1;
                }
                this.pdfDecoder.decodePage(this.currentPage);
                this.pdfDecoder.setPageParameters(1.0f, 1);
                this.pdfDecoder.invalidate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pageCounter2.setText(this.currentPage + "");
            this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
            this.repaint();
        }
    }

    private boolean checkEncryption() {
        if (this.pdfDecoder.isEncrypted()) {
            while (!this.pdfDecoder.isFileViewable()) {
                String string = JOptionPane.showInputDialog(this, (Object)"Please enter password");
                if (string == null) continue;
                this.pdfDecoder.setEncryptionPassword(string);
                this.pdfDecoder.verifyAccess();
            }
            return true;
        }
        return true;
    }

    private void initializeViewer() {
        this.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width / 2, dimension.height / 2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = this.initOpenBut();
        JPanel jPanel = this.initChangerPanel();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new FlowLayout(3, 0, 0));
        jToolBar.add(jButton);
        jToolBar.add(jPanel);
        container.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = this.initPDFDisplay();
        container.add((Component)jScrollPane, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JButton initOpenBut() {
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/open.gif")));
        jButton.setText("Open");
        jButton.setToolTipText("Open a file");
        jButton.setBorderPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelDemo.this.selectFile();
            }
        });
        return jButton;
    }

    private JScrollPane initPDFDisplay() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(this.pdfDecoder);
        return jScrollPane;
    }

    private JPanel initChangerPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        URL uRL = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/start.gif");
        jButton.setIcon(new ImageIcon(uRL));
        jButton.setToolTipText("Rewind to page 1");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage != 1) {
                    JPanelDemo.this.currentPage = 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back to page 1");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setBorderPainted(false);
        URL uRL2 = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/fback.gif");
        jButton2.setIcon(new ImageIcon(uRL2));
        jButton2.setToolTipText("Rewind 10 pages");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 10) {
                    JPanelDemo.this.currentPage -= 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back 10 pages");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setBorderPainted(false);
        URL uRL3 = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/back.gif");
        jButton3.setIcon(new ImageIcon(uRL3));
        jButton3.setToolTipText("Rewind one page");
        jPanel.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 1) {
                    JPanelDemo.this.currentPage -= 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back 1 page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        this.pageCounter2.setEditable(true);
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JPanelDemo.this.pageCounter2.getText().trim();
                try {
                    int n = Integer.parseInt(string);
                    if (n > JPanelDemo.this.pdfDecoder.getPageCount() | n < 1) {
                        return;
                    }
                    JPanelDemo.this.currentPage = n;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("page number entered");
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, ">" + string + "< is Not a valid Value.\nPlease enter a number between 1 and " + JPanelDemo.this.pdfDecoder.getPageCount());
                    return;
                }
            }
        });
        jPanel.add(this.pageCounter1);
        jPanel.add(new JPanel());
        jPanel.add(this.pageCounter2);
        jPanel.add(new JPanel());
        jPanel.add(this.pageCounter3);
        JButton jButton4 = new JButton();
        jButton4.setBorderPainted(false);
        URL uRL4 = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/forward.gif");
        jButton4.setIcon(new ImageIcon(uRL4));
        jButton4.setToolTipText("forward 1 page");
        jPanel.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo.this.currentPage += 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward 1 page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        JButton jButton5 = new JButton();
        jButton5.setBorderPainted(false);
        URL uRL5 = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/fforward.gif");
        jButton5.setIcon(new ImageIcon(uRL5));
        jButton5.setToolTipText("Fast forward 10 pages");
        jPanel.add(jButton5);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount() - 9) {
                    JPanelDemo.this.currentPage += 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward 10 pages");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        JButton jButton6 = new JButton();
        jButton6.setBorderPainted(false);
        URL uRL6 = ClassLoader.getSystemResource("org/jpedal/examples/simpleviewer/end.gif");
        jButton6.setIcon(new ImageIcon(uRL6));
        jButton6.setToolTipText("Fast forward to last page");
        jPanel.add(jButton6);
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo.this.currentPage = JPanelDemo.this.pdfDecoder.getPageCount();
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward to last page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(JPanelDemo.this.currentPage + "");
                }
            }
        });
        return jPanel;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            JPanelDemo jPanelDemo = new JPanelDemo(stringArray[0]);
        } else {
            JPanelDemo jPanelDemo = new JPanelDemo();
        }
    }
}

