/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.function.Function;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    private GenericColorSpace altCS;
    private Function fn;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader pdfObjectReader, String string, Map map) {
        int n;
        Object object;
        Object object2;
        this.value = 10;
        String string2 = "";
        String string3 = "";
        Map map2 = new Hashtable();
        Map map3 = new Hashtable();
        byte[] byArray = null;
        float[] fArray = null;
        float[] fArray2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() > 3) {
            String string4 = stringTokenizer.nextToken();
            this.pantoneName = stringTokenizer.nextToken().substring(1);
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                if (string3.equals("0")) {
                    string2 = string2 + " 0 R";
                    map2 = pdfObjectReader.readObject(string2, false, null);
                    string3 = "";
                    stringTokenizer.nextToken();
                } else {
                    string3 = string3 + " ";
                }
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + stringTokenizer.nextToken() + " ";
                }
                if ((string3 = string3.trim()).endsWith("R")) {
                    map3 = pdfObjectReader.readObject(string3, false, null);
                }
            }
            byArray = pdfObjectReader.readStream(string3);
        } else {
            this.pantoneName = string.substring(11).trim();
            int n2 = this.pantoneName.indexOf("R");
            if (this.pantoneName.startsWith("/")) {
                this.pantoneName = this.pantoneName.substring(1);
                int n3 = this.pantoneName.indexOf("/");
                if (n3 != -1) {
                    string2 = this.pantoneName.substring(n3).trim();
                    this.pantoneName = this.pantoneName.substring(0, n3).trim();
                }
            } else if (n2 != -1) {
                string2 = this.pantoneName.substring(n2 + 1).trim();
                this.pantoneName = pdfObjectReader.getValue(this.pantoneName.substring(0, n2));
                if (string2.endsWith("R")) {
                    string2 = pdfObjectReader.getValue(string2);
                }
            }
            object2 = map.keySet().iterator();
            string2 = "";
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equals("rawValue")) continue;
                string2 = string2 + (String)object;
            }
            map3 = (Map)map.get(string2);
            if (map3 == null) {
                map3 = map;
            }
        }
        int n4 = Integer.parseInt((String)map3.get("FunctionType"));
        object2 = pdfObjectReader.getValue((String)map3.get("Domain"));
        if (object2 != null) {
            object = new StringTokenizer((String)object2, "[] ");
            fArray = new float[((StringTokenizer)object).countTokens()];
            n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                fArray[n] = Float.parseFloat(((StringTokenizer)object).nextToken());
                ++n;
            }
        }
        if ((object2 = pdfObjectReader.getValue((String)map3.get("Range"))) != null) {
            object = new StringTokenizer((String)object2, "[] ");
            fArray2 = new float[((StringTokenizer)object).countTokens()];
            n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                fArray2[n] = Float.parseFloat(((StringTokenizer)object).nextToken());
                ++n;
            }
        }
        this.altCS = ColorspaceDecoder.getColorSpaceInstance(string2, map2, pdfObjectReader);
        if (this.pantoneName != null && this.pantoneName.indexOf("#") != -1) {
            object = new StringBuffer();
            n = this.pantoneName.length();
            for (int i = 0; i < n; ++i) {
                char c = this.pantoneName.charAt(i);
                if (c == '#') {
                    String string5 = this.pantoneName.substring(i + 1, i + 3);
                    ((StringBuffer)object).append((char)Integer.parseInt(string5, 16));
                    i += 2;
                    continue;
                }
                ((StringBuffer)object).append(c);
            }
            this.pantoneName = ((StringBuffer)object).toString();
        }
        this.fn = Function.getInstance(byArray, map3, fArray, fArray2, n4, pdfObjectReader);
    }

    private void setColor(float f) {
        float[] fArray = new float[]{f};
        String[] stringArray = this.fn.compute(fArray);
        this.altCS.setColor(stringArray, stringArray.length);
    }

    public void setColor(String[] stringArray, int n) {
        this.setColor(Float.parseFloat(stringArray[0]));
    }

    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) throws PdfException {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            DataBuffer dataBuffer = raster.getDataBuffer();
            bufferedImage = this.createImage(n3, n4, dataBuffer);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            bufferedImage = this.createImage(n, n2, dataBufferByte);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, DataBuffer dataBuffer) {
        int n3;
        int n4 = dataBuffer.getSize();
        float[] fArray = new float[256];
        for (n3 = 0; n3 < 255; ++n3) {
            fArray[n3] = -1.0f;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = dataBuffer.getElem(n3);
            if (fArray[n5] == -1.0f) {
                this.setColor((float)n5 / 255.0f);
                fArray[n5] = ((Color)this.getColor()).getRed();
            }
            dataBuffer.setElemFloat(n3, fArray[n5]);
        }
        int[] nArray = new int[]{0};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n, n2, n, 1, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public Paint getColor() {
        return this.altCS.getColor();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

