/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private int[] a = new int[256];
    private int[] b = new int[256];
    private int[] c = new int[256];

    public ICCColorSpace(PdfObjectReader pdfObjectReader, String string) {
        byte[] byArray;
        int n;
        for (n = 0; n < 256; ++n) {
            this.a[n] = -1;
            this.b[n] = -1;
            this.c[n] = -1;
        }
        this.value = 7;
        this.cs = ColorSpace.getInstance(1000);
        n = string.indexOf("/ICCBased");
        String string2 = string.substring(n + 9);
        if ((n = string2.indexOf("]")) != -1) {
            string2 = string2.substring(0, n - 1);
        }
        if ((byArray = pdfObjectReader.readStream(string2.trim())) == null) {
            LogWriter.writeLog("Error in reading ICC data with ref " + string2);
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
            }
        }
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f;
            fArray[n - i - 1] = f = Float.parseFloat(stringArray[i]);
            nArray[n - i - 1] = (int)(f * 255.0f);
        }
        if (n == 3 && this.a[nArray[0]] != -1 && this.b[nArray[1]] != -1 && this.c[nArray[2]] != -1) {
            this.currentColor = new Color(this.a[nArray[0]], this.b[nArray[1]], this.c[nArray[2]]);
        } else {
            fArray = this.cs.toRGB(fArray);
            this.currentColor = new Color(fArray[0], fArray[1], fArray[2]);
            if (n == 3) {
                this.a[nArray[0]] = (int)(fArray[0] * 255.0f);
                this.b[nArray[1]] = (int)(fArray[1] * 255.0f);
                this.c[nArray[2]] = (int)(fArray[2] * 255.0f);
            }
        }
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        return this.convert4Index(byArray);
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) throws PdfException {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2);
    }
}

