/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.outlines;

import java.awt.Point;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PageLookup;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutlineData {
    private Document OutlineDataXML;
    private float[] pagesTop;
    private Map pointLookupTable;
    private float[] pagesBottom;
    private String[] refTop;
    private String[] refBottom;
    private String[] lookup;
    private Map fields = new Hashtable();
    private Map keysUsedTable = new Hashtable();

    private OutlineData() {
    }

    public OutlineData(int n) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.OutlineDataXML = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Exception " + parserConfigurationException + " generating XML document");
        }
        this.fields.put("Title", "x");
        String[] stringArray = new String[]{"Title", "Next", "Last"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.keysUsedTable.put(stringArray[i], "x");
        }
        this.pagesTop = new float[++n];
        this.pagesBottom = new float[n];
        this.refTop = new String[n];
        this.refBottom = new String[n];
        this.lookup = new String[n];
        this.pointLookupTable = new HashMap();
    }

    public Document getList() {
        return this.OutlineDataXML;
    }

    public int readOutlineFileMetadata(Object object, PdfObjectReader pdfObjectReader, PageLookup pageLookup) {
        String string;
        LogWriter.writeMethod("{readOutlineFileMetadata " + object + "}", 0);
        int n = 0;
        Map map = object instanceof String ? pdfObjectReader.readObject((String)object, false, null) : (Map)object;
        Object v = map.get("Count");
        if (v != null) {
            n = Integer.parseInt(pdfObjectReader.getValue((String)v));
        }
        if ((string = (String)map.get("First")) != null) {
            Element element = this.OutlineDataXML.createElement("root");
            this.OutlineDataXML.appendChild(element);
            int n2 = 0;
            this.readOutlineLevel(element, pdfObjectReader, pageLookup, string, n2);
        }
        return n;
    }

    public String[] getDefaultBookmarksForPage() {
        return this.lookup;
    }

    private void readOutlineLevel(Element element, PdfObjectReader pdfObjectReader, PageLookup pageLookup, String string, int n) {
        String string2 = "";
        float f = 0.0f;
        Element element2 = this.OutlineDataXML.createElement("title");
        while (true) {
            Object object;
            Object object2;
            byte[] byArray;
            Object object3;
            Map map = pdfObjectReader.readObject(string, false, this.fields);
            String string3 = string;
            f = -1.0f;
            String string4 = (String)map.get("Next");
            String string5 = (String)map.get("Last");
            string = (String)map.get("First");
            Object object4 = (String)map.get("Dest");
            Object v = map.get("A");
            if (v != null) {
                object3 = v instanceof String ? pdfObjectReader.readObject((String)v, false, this.fields) : (Map)v;
                object4 = (String)object3.get("D");
            }
            if ((byArray = pdfObjectReader.getByteTextStringValue(map.get("Title"), this.fields)) != null) {
                string2 = pdfObjectReader.getTextString(byArray);
                element2 = this.OutlineDataXML.createElement("title");
                element.appendChild(element2);
                element2.setAttribute("title", string2);
                object3 = map.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next().toString();
                    if (this.keysUsedTable.containsKey(object2) || (object = map.get(object2)) == null || !(object instanceof String)) continue;
                    element2.setAttribute((String)object2, (String)object);
                }
            }
            if (object4 != null && ((String)object4).startsWith("(")) {
                if ((object4 = pdfObjectReader.convertNameToRef((String)object4)) != null && (object3 = pdfObjectReader.readObject((String)object4, false, null)) != null) {
                    object4 = (String)object3.get("D");
                }
            } else if (object4 != null && (object3 = pdfObjectReader.convertNameToRef((String)object4)) != null && (object4 = object3) != null && (object2 = pdfObjectReader.readObject((String)object4, false, null)) != null) {
                object4 = (String)object2.get("D");
            }
            if (object4 != null) {
                String string6;
                int n2;
                Object object5;
                object3 = "";
                int n3 = -1;
                if (((String)object4).startsWith("[")) {
                    object = new StringTokenizer((String)object4, "[]/ ");
                    if (((StringTokenizer)object).countTokens() > 3) {
                        object3 = ((StringTokenizer)object).nextToken() + " " + ((StringTokenizer)object).nextToken() + " " + ((StringTokenizer)object).nextToken();
                    }
                } else {
                    object3 = object4;
                }
                if ((n3 = pageLookup.convertObjectToPageNumber((String)object3)) == -1 && (object5 = (String)(object = pdfObjectReader.readObject((String)object3, false, null)).get("rawValue")) != null && (n2 = ((String)(object5 = Strip.removeArrayDeleminators((String)object5))).indexOf(" R")) != -1) {
                    object3 = ((String)object5).substring(0, n2 + 2);
                    n3 = pageLookup.convertObjectToPageNumber((String)object3);
                    n2 = ((String)object5).indexOf("/FitH");
                    if (n2 != -1) {
                        string6 = ((String)object5).substring(n2 + 5).trim();
                        f = Float.parseFloat(string6);
                    }
                }
                if (n3 != -1) {
                    element2.setAttribute("page", "" + n3);
                    element2.setAttribute("level", "" + n);
                    element2.setAttribute("objectRef", string3);
                    object = new Integer(n3);
                    if (object4 != null && ((String)object4).indexOf("/XYZ") != -1) {
                        object5 = new StringTokenizer((String)(object4 = ((String)object4).substring(((String)object4).indexOf("/XYZ") + 4)), "[] ");
                        String string7 = ((StringTokenizer)object5).nextToken();
                        if (string7.equals("null")) {
                            string7 = "0";
                        }
                        if ((string6 = ((StringTokenizer)object5).nextToken()).equals("null")) {
                            string6 = "0";
                        }
                        this.pointLookupTable.put(byArray, new Point((int)Float.parseFloat(string7), (int)Float.parseFloat(string6)));
                    }
                    if (this.refTop[n3] == null) {
                        this.pagesTop[n3] = f;
                        this.refTop[n3] = string3;
                        this.pagesBottom[n3] = f;
                        this.refBottom[n3] = string3;
                    } else {
                        object5 = this.refTop[n3];
                        float f2 = this.pagesTop[n3];
                        if (f2 > f && f2 != -1.0f) {
                            this.pagesTop[n3] = f;
                            this.refTop[n3] = string3;
                        }
                        object5 = this.refBottom[n3];
                        f2 = this.pagesBottom[n3];
                        if (f2 < f && f2 != -1.0f) {
                            this.pagesBottom[n3] = f;
                            this.refBottom[n3] = string3;
                        }
                    }
                }
            }
            if (string != null) {
                this.readOutlineLevel(element2, pdfObjectReader, pageLookup, string, n + 1);
            }
            if (string4 == null) break;
            string = string4;
        }
    }
}

