/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import org.jpedal.function.Calculator;
import org.jpedal.function.Exponential;
import org.jpedal.function.Sampled;
import org.jpedal.io.PdfObjectReader;

public abstract class Function {
    float[] domain;
    float[] range = null;

    protected Function() {
    }

    public abstract void compute(float[] var1, float[] var2);

    public abstract String[] compute(float[] var1);

    public int getN() {
        return this.range.length / 2;
    }

    public static Function getInstance(byte[] byArray, Map map, float[] fArray, float[] fArray2, int n, PdfObjectReader pdfObjectReader) {
        Function function = null;
        switch (n) {
            case 0: {
                function = new Sampled(byArray, map, fArray, fArray2, pdfObjectReader);
                break;
            }
            case 2: {
                function = new Exponential(map, fArray, fArray2, pdfObjectReader);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                function = new Calculator(byArray, fArray, fArray2);
            }
        }
        return function;
    }

    Function(float[] fArray, float[] fArray2) {
        this.domain = fArray;
        this.range = fArray2;
    }

    void clip(float[] fArray, float[] fArray2) {
        int n = fArray2.length / 2;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            float f2 = fArray2[i * 2];
            float f3 = fArray2[i * 2 + 1];
            if (f < f2) {
                fArray[i] = f2;
                continue;
            }
            if (!(f > f3)) continue;
            fArray[i] = f3;
        }
    }
}

