/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.function.CustomByteArrayInputStream;
import org.jpedal.function.Function;

class Calculator
extends Function {
    static final Integer FALSE = new Integer(0);
    static final Integer TRUE = new Integer(1);
    static final Character PROC_OPEN = new Character('{');
    static final Character PROC_CLOSE = new Character('}');
    static final Map op2code;
    Object[] cmds_;
    private float[] domain;
    private float[] range;

    Calculator(byte[] byArray, float[] fArray, float[] fArray2) {
        this.range = fArray2;
        this.domain = fArray;
        CustomByteArrayInputStream customByteArrayInputStream = new CustomByteArrayInputStream(byArray);
        try {
            this.readToken(customByteArrayInputStream);
            this.cmds_ = this.parse(customByteArrayInputStream);
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " with Calculator function");
        }
    }

    public final String[] compute(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        try {
            this.compute(fArray, fArray2);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + fArray2[n - i - 1];
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return stringArray;
    }

    public void compute(float[] fArray, float[] fArray2) {
        int n;
        this.clip(fArray, this.domain);
        Number[] numberArray = new Number[100];
        int n2 = 0;
        int n3 = this.domain.length / 2;
        for (n = 0; n < n3; ++n) {
            numberArray[n2++] = new Double(fArray[n]);
        }
        n2 = this.execute(this.cmds_, numberArray, n2);
        n3 = this.range.length / 2;
        for (n = 0; n < n3; ++n) {
            fArray2[n] = numberArray[n].floatValue();
        }
        this.clip(fArray2, this.range);
    }

    Object[] parse(CustomByteArrayInputStream customByteArrayInputStream) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        while (true) {
            Object object;
            if ((object = this.readToken(customByteArrayInputStream)) == PROC_OPEN) {
                arrayList.add(this.parse(customByteArrayInputStream));
                continue;
            }
            if (object == PROC_CLOSE) break;
            if (object instanceof Number) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof Op)) continue;
            Op op = (Op)object;
            if (op.code == 34) {
                op.iftrue = (Op[])arrayList.remove(arrayList.size() - 1);
            } else if (op.code == 35) {
                op.iffalse = (Op[])arrayList.remove(arrayList.size() - 1);
                op.iftrue = (Op[])arrayList.remove(arrayList.size() - 1);
            }
            arrayList.add(op);
        }
        return arrayList.toArray();
    }

    Object readToken(CustomByteArrayInputStream customByteArrayInputStream) {
        Object object;
        int n;
        while ((n = customByteArrayInputStream.read()) != -1 && Character.isWhitespace((char)n)) {
        }
        if (n == 123) {
            object = PROC_OPEN;
        } else if (n == 125 || n == -1) {
            object = PROC_CLOSE;
        } else if (n >= 97 && n <= 122) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            while ((n = customByteArrayInputStream.read()) >= 97 && n <= 122) {
                stringBuffer.append((char)n);
            }
            customByteArrayInputStream.unread(n);
            String string = stringBuffer.toString();
            Integer n2 = (Integer)op2code.get(string);
            object = new Op(string, n2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            boolean bl = false;
            while (true) {
                if ((n = customByteArrayInputStream.read()) >= 48 && n <= 57) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if (n != 46) break;
                bl = true;
            }
            customByteArrayInputStream.unread(n);
            String string = stringBuffer.toString();
            object = bl ? (Number)new Double(string) : (Number)new Integer(string);
        }
        return object;
    }

    int execute(Object[] objectArray, Number[] numberArray, int n) {
        int n2 = objectArray.length;
        block44: for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            if (object instanceof Number) {
                numberArray[n++] = (Number)object;
                continue;
            }
            Op op = (Op)object;
            Number number = n > 0 ? (Number)numberArray[n - 1] : (Number)null;
            switch (op.code) {
                case 0: {
                    numberArray[n - 1] = new Double(Math.abs(number.doubleValue()));
                    continue block44;
                }
                case 1: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() + number.doubleValue());
                    --n;
                    continue block44;
                }
                case 2: {
                    numberArray[n - 1] = new Double(Math.atan(number.doubleValue()));
                    continue block44;
                }
                case 3: {
                    numberArray[n - 1] = new Double(Math.ceil(number.doubleValue()));
                    continue block44;
                }
                case 4: {
                    numberArray[n - 1] = new Double(Math.cos(number.doubleValue()));
                    continue block44;
                }
                case 5: {
                    numberArray[n - 1] = new Integer(number.intValue());
                    continue block44;
                }
                case 6: {
                    numberArray[n - 1] = new Double(number.doubleValue());
                    continue block44;
                }
                case 7: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() / number.doubleValue());
                    --n;
                    continue block44;
                }
                case 8: {
                    numberArray[n - 2] = new Double(Math.pow(numberArray[n - 2].doubleValue(), number.doubleValue()));
                    --n;
                    continue block44;
                }
                case 9: {
                    numberArray[n - 1] = new Double(Math.floor(number.doubleValue()));
                    continue block44;
                }
                case 10: {
                    numberArray[n - 2] = new Integer(numberArray[n - 2].intValue() / number.intValue());
                    --n;
                    continue block44;
                }
                case 11: {
                    numberArray[n - 1] = new Double(Math.log(number.doubleValue()));
                    continue block44;
                }
                case 12: {
                    numberArray[n - 1] = new Double(Math.log(number.doubleValue()) / Math.log(10.0));
                    continue block44;
                }
                case 13: {
                    numberArray[n - 2] = new Integer(number.intValue() % numberArray[n - 2].intValue());
                    --n;
                    continue block44;
                }
                case 14: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() * number.doubleValue());
                    --n;
                    continue block44;
                }
                case 15: {
                    numberArray[n - 1] = new Double(-number.doubleValue());
                    continue block44;
                }
                case 16: {
                    numberArray[n - 1] = new Double(Math.sin(number.doubleValue()));
                    continue block44;
                }
                case 17: {
                    numberArray[n - 1] = new Double(Math.sqrt(number.doubleValue()));
                    continue block44;
                }
                case 18: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() - number.doubleValue());
                    --n;
                    continue block44;
                }
                case 19: {
                    numberArray[n - 1] = new Integer(Math.round(number.floatValue()));
                    continue block44;
                }
                case 20: {
                    numberArray[n - 1] = new Integer((int)number.doubleValue());
                    continue block44;
                }
                case 21: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() & number.intValue());
                    --n;
                    continue block44;
                }
                case 22: {
                    numberArray[n - 2] = new Integer(numberArray[n - 2].intValue() << number.intValue());
                    --n;
                    continue block44;
                }
                case 23: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() == number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 24: {
                    numberArray[n++] = FALSE;
                    continue block44;
                }
                case 25: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() >= number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 26: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() > number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 27: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() <= number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 28: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() < number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 29: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() != number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 30: {
                    numberArray[n - 1] = number == TRUE ? FALSE : (number == FALSE ? TRUE : new Integer(~number.intValue()));
                    continue block44;
                }
                case 31: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() | number.intValue());
                    --n;
                    continue block44;
                }
                case 32: {
                    numberArray[n++] = TRUE;
                    continue block44;
                }
                case 33: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() ^ number.intValue());
                    --n;
                    continue block44;
                }
                case 34: {
                    --n;
                    if (number.intValue() == 0) continue block44;
                    n = this.execute(op.iftrue, numberArray, n);
                    continue block44;
                }
                case 35: {
                    --n;
                    n = this.execute(number.intValue() != 0 ? op.iftrue : op.iffalse, numberArray, n);
                    continue block44;
                }
                case 36: {
                    int n3 = number.intValue();
                    System.arraycopy(numberArray, --n - n3, numberArray, n, n3);
                    n += n3;
                    continue block44;
                }
                case 37: {
                    numberArray[n - 1] = numberArray[n - 2];
                    numberArray[n - 2] = number;
                    continue block44;
                }
                case 38: {
                    --n;
                    continue block44;
                }
                case 39: {
                    numberArray[n++] = number;
                    continue block44;
                }
                case 40: {
                    int n3 = number.intValue();
                    numberArray[--n] = numberArray[n - n3 - 1];
                    ++n;
                    continue block44;
                }
                case 41: {
                    int n3 = numberArray[n - 2].intValue();
                    int n4 = number.intValue();
                }
            }
        }
        return n;
    }

    static {
        String[] stringArray = "abs add atan ceiling cos cvi cvr div exp floor idiv ln log mod mul neg sin sqrt sub round truncate and bitshift eq false ge gt le lt ne not or true xor if ifelse copy exch pop dup index roll".split("\\s+");
        int n = stringArray.length;
        op2code = new HashMap(n * 2);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            op2code.put(stringArray[i], new Integer(i));
        }
    }

    class Op {
        public String op;
        public int code;
        public Op[] iftrue;
        public Op[] iffalse;

        public Op(String string, int n) {
            this.op = string;
            this.code = n;
        }

        public String toString() {
            return this.op + "/" + this.code;
        }
    }
}

