/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.GlyphFactory;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;

public class PdfFont {
    public boolean is1C = false;
    protected String substituteFont = null;
    protected Hashtable charStrings = new Hashtable();
    protected boolean renderPage = false;
    private final float xscale = 0.001f;
    protected float[][] lastTrm = new float[3][3];
    protected int embeddedEnc = 1;
    protected String[] diffs;
    private String fontName = "default";
    public boolean isFontEmbedded = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    protected String baseFontName = "";
    private boolean isDoubleByte = false;
    protected boolean remapFont = false;
    protected String defaultFont = "Lucida Sans";
    private static FontRenderContext frc = new FontRenderContext(null, true, true);
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private String[] diffTable;
    private int fontFlag = 0;
    private float[] widthTable;
    private Font unscaledFont = null;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    protected PdfGlyph[] cachedEmbeddedShapes = null;
    protected Area[] cachedShapes = null;
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    protected String[] CMAP;
    protected String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    private static String[] fontList;

    public PdfFont() {
    }

    public PdfFont(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public static void setStandardFontMappings() {
        int n;
        int n2 = StandardFonts.files_names.length;
        for (n = 0; n < n2; ++n) {
            PdfDecoder.fontSubstitutionAliasTable.put(StandardFonts.files_names_bis[n].toLowerCase(), StandardFonts.javaFonts[n].toLowerCase());
        }
        for (n = 0; n < n2; ++n) {
            PdfDecoder.fontSubstitutionAliasTable.put(StandardFonts.files_names[n].toLowerCase(), StandardFonts.javaFonts[n].toLowerCase());
            StandardFonts.javaFontList.put(StandardFonts.files_names[n], "x");
        }
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    protected final void setCIDFontDefaultWidth(String string) {
        this.defaultWidth = Float.parseFloat(string) / 1000.0f;
    }

    protected final void setCIDFontWidths(String string) {
        string = string.substring(1, string.length() - 1).trim();
        this.widthTable = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            this.widthTable[i] = -1.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        String string2 = "";
        block1: while (stringTokenizer.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            int n = Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (string2.equals("[")) {
                while (true) {
                    if ((string2 = stringTokenizer.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (string2.equals("]")) continue block1;
                    this.widthTable[n] = Float.parseFloat(string2) / 1000.0f;
                    ++n;
                }
            }
            int n2 = 1 + Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            for (int i = n; i < n2; ++i) {
                this.widthTable[i] = Float.parseFloat(string2) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
    }

    private final String getUnicodeMapping(int n) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[n];
    }

    protected final void putFontEncoding(int n) {
        this.fontEnc = n;
        StandardFonts.checkLoaded(n);
    }

    public Area getStandardGlyph(float[][] fArray, int n, String string, float f) {
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        Area area = this.getCachedShape(n);
        double d = -1.0;
        double d2 = 1.0;
        if (fArray[1][0] < 0.0f & fArray[0][1] >= 0.0f | fArray[0][1] < 0.0f & fArray[1][0] >= 0.0f) {
            d2 = 1.0;
            d = -1.0;
        }
        if (area == null) {
            String string2 = string;
            if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
                string2 = "" + (char)(n + 61440);
            }
            area = this.getGlyph(n, string, f);
            AffineTransform affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, 0.0);
            area.transform(affineTransform);
            this.setCachedShape(n, area);
        }
        return area;
    }

    public final String getGlyphValue(int n) {
        String string = null;
        if (this.isCIDFont) {
            String string2 = this.getUnicodeMapping(n);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                String string3 = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    string = this.diffTable[n];
                } else if (string3 != null) {
                    String string4;
                    if (string3.startsWith("Identity-")) {
                        string = "" + (char)n;
                    } else if (this.CMAP != null && (string4 = this.CMAP[n]) != null) {
                        string = string4;
                    }
                }
                if (string == null) {
                    string = "" + (char)n;
                }
            }
        } else {
            string = this.getStandardGlyphValue(n);
        }
        return string;
    }

    private final void handleCIDEncoding(String string) {
        String string2 = "";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.CIDfontEncoding = string;
        if (string.startsWith("Identity-")) {
            this.isDoubleByte = true;
        } else {
            this.CMAP = new String[65536];
            if (string.equals("ETenms-B5-H")) {
                string = "ETen-B5-H";
            } else if (string.equals("ETenms-B5-V")) {
                string = "ETen-B5-V";
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + string), "Cp1252"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem reading encoding for CID font " + this.fontID + " " + string + " Check CID.jar installed");
            }
            if (string.equals("UniJIS-UCS2-H")) {
                this.isDoubleByte = true;
            }
            if (bufferedReader != null) {
                while (true) {
                    try {
                        string2 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 == null) break;
                    if (string2.indexOf("endcidrange") != -1) {
                        bl = false;
                    }
                    if (bl) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " <>[]");
                        boolean bl2 = false;
                        if (string2.indexOf("[") != -1) {
                            bl2 = true;
                        }
                        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        for (int i = n; i < n2 + 1; ++i) {
                            if (bl2) {
                                n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                                this.CMAP[i] = "" + (char)n3;
                                continue;
                            }
                            this.CMAP[i] = "" + (char)n3;
                            ++n3;
                        }
                    }
                    if (string2.indexOf("begincidrange") == -1) continue;
                    bl = true;
                }
            }
        }
    }

    public final String getStandardGlyphValue(int n) {
        String string = "";
        String string2 = null;
        String string3 = null;
        int n2 = this.getFontEncoding(true);
        string2 = this.getUnicodeMapping(n);
        string3 = this.getMappedChar(n, true);
        if (string2 != null) {
            string = string2;
        } else if (string3 != null) {
            String string4 = StandardFonts.getUnicodeName(this.fontName + string3);
            if (string4 != null) {
                string = string4;
            } else {
                string4 = StandardFonts.getUnicodeName(string3);
                if (string4 != null) {
                    string = string4;
                } else if (string3.length() == 1) {
                    string = string3;
                } else if (string3.length() > 1) {
                    char c = string3.charAt(0);
                    if (c == 'B' | c == 'C' | c == 'c' | c == 'G') {
                        string3 = string3.substring(1);
                        try {
                            int n3 = this.isHex ? Integer.valueOf(string3, 16) : Integer.parseInt(string3);
                            string = "" + (char)n3;
                        }
                        catch (Exception exception) {
                            string = "";
                        }
                    } else {
                        string = "";
                    }
                } else {
                    string = "";
                }
            }
        } else if (n2 > -1) {
            string = StandardFonts.getEncodedChar(n2, n);
        }
        return string;
    }

    protected final void setFont(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(",");
        if (n2 == -1 && StandardFonts.javaFontList.get(string) != null) {
            n2 = string.indexOf("-");
        }
        if (n2 != -1) {
            string3 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string.toLowerCase());
            string2 = string.substring(n2 + 1, string.length()).toLowerCase();
            if (string2.indexOf("bold") != -1) {
                n = 1;
            } else if (string2.indexOf("roman") != -1) {
                n = 0;
            }
            if (string2.indexOf("italic") != -1) {
                n += 2;
            } else if (string2.indexOf("oblique") != -1) {
                n += 2;
            }
            string = string.substring(0, n2);
        }
        if (string3 == null) {
            string3 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string.toLowerCase());
        }
        if (string3 != null) {
            string = string3;
        }
        if (fontList != null) {
            int n3 = fontList.length;
            for (int i = 0; i < n3; ++i) {
                if (!fontList[i].toLowerCase().equals(string.toLowerCase())) continue;
                bl = true;
                string = fontList[i];
                i = n3;
            }
        }
        if (!bl) {
            if (string2 == null) {
                String string4 = string.toLowerCase();
                if (string4.indexOf("heavy") != -1) {
                    n = 1;
                } else if (string4.indexOf("bold") != -1) {
                    n = 1;
                } else if (string4.indexOf("roman") != -1) {
                    n = 0;
                }
                if (string4.indexOf("italic") != -1) {
                    n += 2;
                } else if (string4.indexOf("oblique") != -1) {
                    n += 2;
                }
            }
            string = this.defaultFont;
        }
        this.unscaledFont = new Font(string, n, 1);
    }

    public final void setDefaultDisplayFont(String string) throws PdfFontException {
        this.defaultFont = string;
    }

    private final Font getUnscaledFont() {
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    protected final void readGenericFontMetadata(Map map) {
        int n;
        Object object;
        LogWriter.writeMethod("{readGenericFontMetadata " + this.fontID + "}", 0);
        String string = (String)map.get("FontMatrix");
        if (string != null) {
            object = new StringTokenizer(string, "[] ");
            for (n = 0; n < 6; ++n) {
                this.FontMatrix[n] = Float.parseFloat(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = (String)map.get("FontBBox")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "[] ");
            for (int i = 0; i < 4; ++i) {
                this.FontBBox[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        this.baseFontName = this.currentPdfFile.getValue((String)map.get("BaseFont"));
        if (this.baseFontName == null) {
            this.baseFontName = this.currentPdfFile.getValue((String)map.get("FontName"));
        }
        this.baseFontName = this.baseFontName == null ? this.fontID : this.baseFontName.substring(1);
        this.fontName = this.baseFontName;
        n = this.baseFontName.indexOf("+");
        if (n == 6) {
            this.fontName = this.baseFontName.substring(n + 1);
        }
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.fontName);
        return this.fontName;
    }

    public final String getRawFontName() {
        return this.baseFontName;
    }

    protected final int getFontEncoding(boolean bl) {
        int n = this.fontEnc;
        if (n == -1 && bl) {
            n = 1;
        }
        return n;
    }

    public final float getWidth(int n) {
        float f = -1.0f;
        if (this.widthTable != null) {
            f = this.widthTable[n];
        }
        if (f == -1.0f) {
            if (this.isCIDFont) {
                f = this.defaultWidth;
            } else {
                Float f2;
                String string = this.getMappedChar(n, false);
                if (string != null && string.equals(".notdef")) {
                    string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
                }
                f = (f2 = StandardFonts.getStandardWidth(this.fontName, string)) != null ? f2.floatValue() : 0.0f;
            }
        }
        return f;
    }

    public Map createCIDFont(Map map, Map map2) {
        String string;
        Object object;
        Object object2;
        Object v;
        String string2;
        String string3;
        String string4;
        Map map3 = null;
        String string5 = (String)map.get("Encoding");
        if (string5 != null) {
            this.handleCIDEncoding(string5);
        }
        if ((string4 = (String)map.get("ToUnicode")) != null) {
            this.readUnicode(string4, this.fontID);
        }
        if ((string3 = this.currentPdfFile.getValue((String)map2.get("W"))) != null) {
            this.setCIDFontWidths(string3);
        }
        if ((string2 = this.currentPdfFile.getValue((String)map2.get("DW"))) != null) {
            this.setCIDFontDefaultWidth(string2);
        }
        if ((v = map2.get("CIDToGIDMap")) != null) {
            if (v instanceof String) {
                object2 = (String)v;
                if (((String)object2).endsWith(" R")) {
                    object = this.currentPdfFile.readStream((String)object2);
                    for (int i = 0; i < ((Object)object).length; i += 2) {
                        char c = (char)((object[i] << 8) + object[i + 1]);
                        this.putMappedChar(i, "" + c);
                    }
                } else if (((String)object2).equals("/Identity")) {
                    this.handleCIDEncoding("Identity-");
                } else {
                    LogWriter.writeLog(ObjectStore.fullFileName + "not yet supported in demo.");
                    System.err.println(ObjectStore.fullFileName + "not yet supported in demo.");
                }
            } else {
                LogWriter.writeLog(ObjectStore.fullFileName + "not yet supported in demo.");
                System.err.println(ObjectStore.fullFileName + "not yet supported in demo.");
            }
        }
        object2 = map2.get("CIDSystemInfo");
        object = new Hashtable();
        object = object2 instanceof Map ? (Map)object2 : this.currentPdfFile.readObject((String)object2, false, null);
        String string6 = (String)object.get("Ordering");
        if (string6 != null) {
            if (string6.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
            } else if (string6.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + string6);
            } else if (string6.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + string6);
            }
            if (this.substituteFontName != null) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + string6);
            }
        }
        if ((string = (String)map2.get("FontDescriptor")) != null && string.length() > 1) {
            map3 = this.currentPdfFile.readObject(string, false, null);
            this.readGenericFontMetadata(map3);
        }
        return map3;
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(Map map) throws Exception {
        LogWriter.writeMethod("{readWidths}" + map, 0);
        String string = (String)map.get("FirstChar");
        int n = 1;
        if (string != null) {
            n = ToInteger.getInteger(string);
        }
        String string2 = (String)map.get("LastChar");
        boolean bl = false;
        String string3 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string3 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            String string4 = string3.substring(1, string3.length() - 1).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int n2 = ToInteger.getInteger(string2);
            float f = (float)(1.0 / this.FontMatrix[0]);
            if (f < 0.0f) {
                f = -f;
            }
            for (int i = n; i < n2 + 1; ++i) {
                float f2;
                if (!stringTokenizer.hasMoreTokens()) {
                    f2 = 0.0f;
                    continue;
                }
                f2 = this.fontTypes == 3 ? Float.parseFloat(stringTokenizer.nextToken()) / f : Float.parseFloat(stringTokenizer.nextToken()) * 0.001f;
                this.widthTable[i] = f2;
            }
        }
    }

    public Map createFont(Map map, String string, boolean bl, Map map2) throws Exception {
        int n;
        Object object;
        Object object2;
        String string2;
        LogWriter.writeMethod("{readNonCIDFont}" + map + "{render=" + bl, 0);
        if (fontList == null & bl) {
            fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        this.fontID = string;
        this.renderPage = bl;
        this.readGenericFontMetadata(map);
        String string3 = (String)map.get("Subtype");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = (String)map.get("ToUnicode")) != null) {
            this.readUnicode(string2, string);
        }
        String string4 = (String)map.get("FirstChar");
        int n2 = 1;
        if (string4 != null) {
            n2 = ToInteger.getInteger(string4);
        }
        String string5 = (String)map.get("LastChar");
        boolean bl2 = false;
        String string6 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string6 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            object2 = string6.substring(1, string6.length() - 1).trim();
            object = new StringTokenizer((String)object2);
            int n3 = ToInteger.getInteger(string5) + 1;
            float f = -1.0f;
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            f2 = -f2;
            for (n = n2; n < n3; ++n) {
                f = !((StringTokenizer)object).hasMoreTokens() ? 0.0f : (this.fontTypes == 3 ? Float.parseFloat(((StringTokenizer)object).nextToken()) / f2 : Float.parseFloat(((StringTokenizer)object).nextToken()) * 0.001f);
                this.widthTable[n] = f;
            }
        }
        if ((object2 = map.get("Encoding")) != null) {
            if (object2 instanceof String) {
                this.handleFontEncoding((String)object2, null, string3);
            } else {
                this.handleFontEncoding("", (Hashtable)object2, string3);
            }
        } else {
            this.putFontEncoding(1);
            this.hasEncoding = false;
        }
        object = (String)map.get("FontDescriptor");
        Map map3 = null;
        if (object != null && ((String)object).length() > 1) {
            map3 = this.currentPdfFile.readObject((String)object, false, null);
            int n4 = 0;
            String string7 = (String)map3.get("Flags");
            if (string7 != null) {
                n4 = Integer.parseInt(string7);
            }
            this.fontFlag = n4;
            this.remapFont = false;
            n = this.fontFlag;
            if ((n & 4) == 4) {
                this.remapFont = true;
            }
            map3 = this.currentPdfFile.readObject((String)object, false, null);
        }
        return map3;
    }

    private final void handleFontEncoding(String string, Map map, String string2) {
        int n = this.getFontEncoding(false);
        String string3 = "";
        int n2 = n;
        if (n2 == -1) {
            n2 = string2.equals("/TrueType") ? 0 : 1;
        }
        if (string.indexOf(" ") != -1 | map != null) {
            String string4;
            String string5;
            if (map == null) {
                map = this.currentPdfFile.readObject(string, false, null);
            }
            if ((string5 = this.currentPdfFile.getValue((String)map.get("BaseEncoding"))) != null) {
                if (string5.startsWith("/")) {
                    string5 = string5.substring(1);
                }
                string3 = string5;
                this.hasEncoding = true;
            }
            if ((string4 = this.currentPdfFile.getValue((String)map.get("Differences"))) != null) {
                string4 = Strip.removeArrayDeleminators(string4);
                int n3 = 0;
                String string6 = " \r\n";
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " /\r\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string6.indexOf(string7) != -1) continue;
                    if (string7.equals("/")) {
                        string7 = stringTokenizer.nextToken();
                        while (string6.indexOf(string7) != -1) {
                            string7 = stringTokenizer.nextToken();
                        }
                        this.putMappedChar(n3, string7);
                        ++n3;
                        char c = string7.charAt(0);
                        if (!(c == 'B' | c == 'c' | c == 'C' | c == 'G')) continue;
                        int n4 = 1;
                        int n5 = string7.length();
                        while (!this.isHex && n4 < n5) {
                            this.isHex = Character.isLetter(string7.charAt(n4++));
                        }
                        continue;
                    }
                    if (!Character.isDigit(string7.charAt(0))) continue;
                    n3 = Integer.parseInt(string7);
                }
            }
        } else {
            string3 = string;
        }
        if (string3.indexOf("MacRomanEncoding") != -1) {
            n2 = 0;
        } else if (string3.indexOf("WinAnsiEncoding") != -1) {
            n2 = 2;
        } else if (string3.indexOf("MacExpertEncoding") != -1) {
            n2 = 3;
        } else if (string3.indexOf("STD") == -1 & n2 == -1) {
            LogWriter.writeLog("Encoding type " + string3 + " not implemented");
        }
        if (n2 > -1) {
            this.putFontEncoding(n2);
        }
    }

    protected final void putMappedChar(int n, String string) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (this.diffTable[n] == null) {
            this.diffTable[n] = string;
        }
    }

    protected final void setCachedShape(int n, Area area) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            this.cachedShapes = areaArray = new Area[this.maxCharCount];
        }
        areaArray[n] = (Area)area.clone();
    }

    protected final void setEmbeddedCachedShape(int n, PdfGlyph pdfGlyph) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            this.cachedEmbeddedShapes = pdfGlyphArray = new PdfGlyph[this.maxCharCount];
        }
        pdfGlyphArray[n] = pdfGlyph;
    }

    public double getType3Ydisplacement(int n) {
        return 0.0;
    }

    public final String getMappedChar(int n, boolean bl) {
        String string = null;
        if (this.diffTable != null) {
            string = this.diffTable[n];
        }
        if (bl && string != null && string.equals(".notdef")) {
            string = " ";
        }
        if (string == null) {
            string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
        }
        if (this.isFontEmbedded && string == null) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final String getEmbeddedChar(int n) {
        String string = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final void readUnicode(String string, String string2) {
        Object object;
        String string3 = "";
        int n = 0;
        BufferedReader bufferedReader = null;
        this.unicodeMappings = new String[this.maxCharCount];
        try {
            object = this.currentPdfFile.readStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])object)));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up text object " + exception);
        }
        if (bufferedReader != null) {
            while (true) {
                int n2;
                int n3;
                String string4;
                int n4;
                try {
                    string3 = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception reading unicode object " + exception);
                }
                if (string3 == null) break;
                if (string3.indexOf("endbf") != -1) {
                    n = 0;
                }
                if (n == 1) {
                    object = new StringTokenizer(string3, " <>[]");
                    n4 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                    string4 = ((StringTokenizer)object).nextToken();
                    String string5 = "";
                    if (string4.length() < 4) {
                        n3 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        string5 = String.valueOf((char)n3);
                    } else {
                        for (n2 = 0; n2 < string4.length(); n2 += 4) {
                            n3 = Integer.parseInt(string4.substring(n2, n2 + 4), 16);
                            string5 = string5 + String.valueOf((char)n3);
                        }
                    }
                    this.unicodeMappings[n4] = string5;
                } else if (n == 2) {
                    object = new StringTokenizer(string3, " <>[]");
                    n4 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                    int n5 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                    string4 = "";
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = string4 + ((StringTokenizer)object).nextToken();
                    }
                    int n6 = 0;
                    for (n2 = n4; n2 < n5 + 1; ++n2) {
                        String string6 = "";
                        int n7 = string4.length();
                        for (int i = 0; i < n7; i += 4) {
                            n3 = Integer.parseInt(string4.substring(i, i + 4), 16);
                            if (n2 + 4 > n7) {
                                n3 += n6;
                            }
                            string6 = string6 + String.valueOf((char)n3);
                        }
                        this.unicodeMappings[n2] = string6;
                        ++n6;
                    }
                }
                if (string3.indexOf("beginbfchar") != -1) {
                    n = 1;
                    continue;
                }
                if (string3.indexOf("beginbfrange") == -1) continue;
                n = 2;
            }
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public Area getApproximateGlyph(float[][] fArray, int n, String string, float f) {
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        Area area = this.getCachedShape(n);
        double d = -1.0;
        double d2 = 1.0;
        if (fArray[1][0] < 0.0f & fArray[0][1] >= 0.0f | fArray[0][1] < 0.0f & fArray[1][0] >= 0.0f) {
            d2 = 1.0;
            d = -1.0;
        }
        if (area == null) {
            double d3;
            double d4;
            String string2 = string;
            if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
                string2 = "" + (char)(n + 61440);
            }
            GlyphVector glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
            area = new Area(glyphVector.getOutline());
            double d5 = glyphVector.getOutline().getBounds2D().getX();
            AffineTransform affineTransform = null;
            if (d5 < 0.0) {
                d5 = -d5;
                affineTransform = AffineTransform.getTranslateInstance(d5 * 2.0, 0.0);
                area.transform(affineTransform);
            }
            if ((d4 = (double)f / (d3 = glyphVector.getVisualBounds().getWidth() + d5 * 2.0)) < 1.0) {
                affineTransform = AffineTransform.getScaleInstance(d4, 1.0);
                area.transform(affineTransform);
            }
            affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, 0.0);
            area.transform(affineTransform);
            this.setCachedShape(n, area);
        }
        return area;
    }

    protected Area getGlyph(int n, String string, float f) {
        double d;
        Object object;
        boolean bl = true;
        GlyphVector glyphVector = null;
        String string2 = string;
        if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = "" + (char)(n + 61440);
        }
        if (!this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = string;
            bl = false;
        }
        if (bl) {
            glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
        } else {
            object = new Font(this.defaultFont, 0, 1);
            glyphVector = ((Font)object).createGlyphVector(frc, string2);
        }
        object = new Area(glyphVector.getOutline());
        double d2 = glyphVector.getOutline().getBounds2D().getX();
        AffineTransform affineTransform = null;
        if (d2 < 0.0) {
            d2 = -d2;
            affineTransform = AffineTransform.getTranslateInstance(d2, 0.0);
            ((Area)object).transform(affineTransform);
        }
        if ((d = (double)f / ((Area)object).getBounds2D().getWidth()) < 1.0) {
            affineTransform = AffineTransform.getScaleInstance(d, 1.0);
            ((Area)object).transform(affineTransform);
        }
        return object;
    }

    protected final Area getCachedShape(int n) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            return null;
        }
        Area area = areaArray[n];
        if (area == null) {
            return null;
        }
        return (Area)area.clone();
    }

    protected final PdfGlyph getEmbeddedCachedShape(int n) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            return null;
        }
        PdfGlyph pdfGlyph = pdfGlyphArray[n];
        if (pdfGlyph == null) {
            return null;
        }
        return pdfGlyph;
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f) {
        return null;
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int n) {
        if (this.CMAP == null) {
            return false;
        }
        System.out.println(this.CMAP[n] + "<<" + n);
        return this.CMAP[n] != null;
    }
}

