/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.gui.Hotspots;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfPageData;
import org.jpedal.renderer.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPanel
extends JPanel {
    private boolean showCrop = false;
    private boolean drawRotatedPage = false;
    protected boolean displayViewportBorder = false;
    private int rotation = 0;
    private Point current_p;
    protected Rectangle viewableArea = null;
    protected PdfAnnots annotsData;
    private Vector_Int merge_level;
    private Vector_Shape merge_outline;
    private boolean[] showDebugLevel;
    private Color[] debugColors;
    private boolean showMerging = false;
    private boolean tooltipsAreInitialised = false;
    private RepaintManager currentManager = RepaintManager.currentManager(this);
    protected int pageNumber;
    private AffineTransform displayScaling;
    protected AffineTransform viewScaling = null;
    protected PdfPageData pageData = new PdfPageData();
    protected PageLines pageLines;
    private Rectangle lastHighlight = null;
    public Rectangle cursorBoxOnScreen = null;
    public Rectangle lastCursorBoxOnScreen = null;
    private boolean drawCrossHairs = false;
    private Color outlineColor;
    private Rectangle currentHighlightedObject = null;
    private Color outlineHighlightColor;
    private Color[] highlightColors;
    private final int strip = 2;
    private Rectangle2D[] outlineZone = null;
    protected int insetW = 0;
    protected int insetH = 0;
    private boolean[] highlightedZonesSelected = null;
    private int defaultSize;
    private int y_size = this.defaultSize = 100;
    private int max_y;
    private int volatileWidth;
    private int volatileHeight;
    private int x_size = this.defaultSize;
    int[] cx = null;
    int[] cy = null;
    protected int raw_rotation = 0;
    protected float scaling = 1.0f;
    private Vector_String toolTipText;
    private Vector_Rectangle toolTipRectangle;
    private Vector_Int ttType;
    private Vector_Int toolTipPage;
    private int tooltipsCount = 0;
    private int highlightMode = 0;
    public static final int SHOW_OBJECTS = 1;
    public static final int SHOW_LINES = 2;
    protected int size = 20;
    protected Font highlightFont = null;
    protected Border myBorder = null;
    public static final int OUTLINE_CURRENT = 2;
    public static final int SHOW_SELECTED = 4;
    public static final int TEXT_TOOLTIP = 8;
    public static final int MASTER_TOOLTIP = 16;
    protected DropTarget dropTarget = null;
    protected DynamicVectorRenderer currentDisplay = new DynamicVectorRenderer();
    Hotspots displayHotspots;
    Hotspots printHotspots;
    Hashtable userAnnotIcons;
    protected boolean useBorder = true;
    private int[] selectionOrder;
    private Rectangle[] areas;
    private Object[] linkedItems;
    private int[] parents;
    private Shape[] fragmentShapes;
    private int x_size_cropped;
    private int y_size_cropped;
    public static boolean isFlushing = false;
    private boolean useAcceleration = true;
    protected boolean screenNeedsRedrawing;
    protected boolean overRideAcceleration = false;
    protected VolatileImage backBuffer = null;

    private void createBackBuffer() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
            this.backBuffer = null;
        }
        try {
            if (this.volatileWidth > 0 && this.volatileHeight > 0) {
                if (this.raw_rotation == 0 | this.raw_rotation == 180) {
                    this.backBuffer = this.createVolatileImage((int)((float)this.volatileWidth * this.scaling + (float)(this.insetW * 2)), (int)((float)this.volatileHeight * this.scaling + (float)(this.insetH * 2)));
                } else if (this.raw_rotation == 90 | this.raw_rotation == 270) {
                    this.backBuffer = this.createVolatileImage((int)((float)this.volatileHeight * this.scaling + (float)(this.insetH * 2)), (int)((float)this.volatileWidth * this.scaling + (float)(this.insetW * 2)));
                }
            }
        }
        catch (Error error) {
            this.overRideAcceleration = true;
        }
    }

    protected final void flushToolTips() {
        this.toolTipText = new Vector_String(100);
        this.toolTipRectangle = new Vector_Rectangle(100);
        this.ttType = new Vector_Int(100);
        this.toolTipPage = new Vector_Int(100);
        this.tooltipsCount = 0;
    }

    public final void addMergingDisplayForDebugging(Vector_Int vector_Int, Vector_Shape vector_Shape, int n, Color[] colorArray) {
        this.merge_level = vector_Int;
        this.merge_outline = vector_Shape;
        this.showDebugLevel = new boolean[n];
        this.debugColors = colorArray;
    }

    public final void setDebugView(int n, boolean bl) {
        if (this.showDebugLevel != null) {
            this.showDebugLevel[n] = bl;
        }
    }

    public final BufferedImage getPageAsThumbnail(int n) {
        BufferedImage bufferedImage = this.getImageFromRenderer(n, this.currentDisplay, this.pageNumber);
        return bufferedImage;
    }

    protected BufferedImage getImageFromRenderer(int n, DynamicVectorRenderer dynamicVectorRenderer, int n2) {
        int n3 = this.pageData.getMediaBoxWidth(n2);
        int n4 = this.pageData.getMediaBoxHeight(n2);
        int n5 = this.pageData.getMediaBoxX(n2);
        int n6 = this.pageData.getMediaBoxY(n2);
        int n7 = this.pageData.getCropBoxWidth(n2);
        int n8 = this.pageData.getCropBoxHeight(n2);
        int n9 = this.pageData.getCropBoxX(n2);
        int n10 = this.pageData.getCropBoxY(n2);
        if (n10 > 0) {
            n10 = n4 - n8 - n10;
        }
        float f = (float)n / (float)n8;
        int n11 = this.pageData.getRotation(n2);
        int n12 = -1;
        if (n11 == 90 | n11 == 270) {
            int n13 = n7;
            n7 = n8;
            n8 = n13;
            n12 = 1;
            n13 = n9;
            n9 = n10;
            n10 = n13;
        }
        AffineTransform affineTransform = this.getScalingForImage(n11, (int)((float)n3 * f), (int)((float)n4 * f), f);
        int n14 = n5 - n9;
        int n15 = n6 - n10;
        affineTransform.translate(n14, n12 * n15);
        BufferedImage bufferedImage = dynamicVectorRenderer.getPageAsImage(f, n9, n10, n7, n8, n2, affineTransform, 1);
        return bufferedImage;
    }

    public final void setHighlightedZones(int n, int[] nArray, int[] nArray2, Shape[] shapeArray, Object[] objectArray, int[] nArray3, Rectangle2D[] rectangle2DArray, boolean[] blArray, Color[] colorArray, int[] nArray4) {
        this.cx = nArray;
        this.cy = nArray2;
        this.fragmentShapes = shapeArray;
        this.linkedItems = objectArray;
        this.parents = nArray3;
        this.outlineZone = rectangle2DArray;
        this.highlightedZonesSelected = blArray;
        this.highlightMode = n;
        this.highlightColors = colorArray;
        this.selectionOrder = nArray4;
    }

    public final void createToolTip(int n, String string, Rectangle rectangle, int n2) {
        if (!this.tooltipsAreInitialised) {
            this.tooltipsAreInitialised = true;
            this.toolTipText = new Vector_String(100);
            this.toolTipRectangle = new Vector_Rectangle(100);
            this.ttType = new Vector_Int(100);
            this.toolTipPage = new Vector_Int(100);
        }
        this.toolTipRectangle.addElement(rectangle);
        this.toolTipText.addElement(string);
        this.ttType.addElement(n);
        this.toolTipPage.addElement(n2);
        ++this.tooltipsCount;
    }

    public void setDebugDisplay(boolean bl) {
        this.showMerging = bl;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void ensurePointIsVisible(Point point) {
        super.scrollRectToVisible(new Rectangle(point.x, this.y_size - point.y, 20, 40));
    }

    public final Dimension getMaximumSize() {
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            return new Dimension(this.y_size_cropped + this.insetW + this.insetW, this.x_size_cropped + this.insetH + this.insetH);
        }
        return new Dimension(this.x_size_cropped + this.insetW + this.insetW, this.y_size_cropped + this.insetH + this.insetH);
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public void setHighlightedAreas(Rectangle[] rectangleArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        if (rectangleArray != null) {
            Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (rectangleArray[i] == null) continue;
                if (bl) {
                    d = rectangleArray[i].getMinX();
                    d2 = rectangleArray[i].getMinY();
                    d3 = rectangleArray[i].getMaxX();
                    d4 = rectangleArray[i].getMaxY();
                } else {
                    double d5 = rectangleArray[i].getMinX();
                    double d6 = rectangleArray[i].getMinY();
                    double d7 = rectangleArray[i].getMaxX();
                    double d8 = rectangleArray[i].getMaxY();
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d7 > d3) {
                        d3 = d7;
                    }
                    if (d8 > d4) {
                        d4 = d8;
                    }
                }
                rectangleArray2[i] = new Rectangle(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
            }
            this.areas = rectangleArray2;
            this.currentManager.addDirtyRegion(this, 0, 0, this.x_size, this.y_size);
        } else {
            this.areas = null;
        }
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        this.current_p = new Point((int)((point.getX() - (double)this.insetW) / (double)this.scaling), (int)(((double)(this.y_size + this.insetH) - point.getY()) / (double)this.scaling));
        if (this.displayHotspots != null) {
            string = this.displayHotspots.getTooltip(this.current_p, this.userAnnotIcons, this.pageNumber);
        }
        return string;
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
        this.cursorBoxOnScreen = rectangle != null ? new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
        this.outlineColor = color;
        int n = 30;
        if (this.lastCursorBoxOnScreen != null) {
            if (this.raw_rotation == 90 | this.raw_rotation == 270) {
                this.currentManager.addDirtyRegion(this, 0, 0, this.y_size + this.max_y, this.x_size);
            } else {
                this.currentManager.addDirtyRegion(this, (int)((float)this.lastCursorBoxOnScreen.x * this.scaling) - n, (int)((float)(this.max_y - this.lastCursorBoxOnScreen.y - this.lastCursorBoxOnScreen.height) * this.scaling) - n, (int)((float)this.lastCursorBoxOnScreen.width * this.scaling) + n + n, (int)((float)this.lastCursorBoxOnScreen.height * this.scaling) + n + n);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            this.currentManager.addDirtyRegion(this, (int)((float)this.cursorBoxOnScreen.x * this.scaling) - n, (int)((float)(this.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * this.scaling) - n, (int)((float)this.cursorBoxOnScreen.width * this.scaling) + n + n, (int)((float)this.cursorBoxOnScreen.height * this.scaling) + n + n);
        }
        if (this.viewScaling != null) {
            this.currentManager.markCompletelyDirty(this);
        }
    }

    public void repaintArea(Rectangle rectangle, int n) {
        int n2 = 10;
        if (n2 < this.insetH) {
            n2 = this.insetH;
        }
        if (n2 < this.insetW) {
            n2 = this.insetW;
        }
        this.currentManager.addDirtyRegion(this, (int)((float)rectangle.x * this.scaling) - n2, (int)((float)(n - rectangle.y - rectangle.height) * this.scaling) - n2, (int)((float)(rectangle.x + rectangle.width) * this.scaling) + n2 + n2, (int)((float)(rectangle.y + rectangle.height) * this.scaling) + n2 + n2);
    }

    public final void removeHiglightedObject() {
        if (this.lastHighlight != null) {
            this.currentManager.addDirtyRegion(this, this.lastHighlight.x - 2, this.lastHighlight.y - 2, this.lastHighlight.width + 2 + 2, this.lastHighlight.height + 2 + 2);
            this.currentHighlightedObject = null;
        }
    }

    public final void addHiglightedObject(Rectangle rectangle, Color color) {
        this.currentHighlightedObject = rectangle;
        this.outlineHighlightColor = color;
        if (this.currentHighlightedObject != null && this.currentHighlightedObject != this.lastHighlight) {
            this.currentManager.addDirtyRegion(this, this.currentHighlightedObject.x - 2, this.currentHighlightedObject.y - 2, this.currentHighlightedObject.width + 2 + 2, this.currentHighlightedObject.height + 2 + 2);
            this.lastHighlight = this.currentHighlightedObject;
        }
    }

    public void paintComponent(Graphics graphics) {
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("PaintComponent called ");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(graphics);
        } else {
            final Graphics graphics2 = graphics;
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfPanel.this.threadSafePaint(graphics2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void threadSafePaint(Graphics graphics) {
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("threadsafePaint called ");
        }
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = null;
        Object var5_5 = null;
        double d = (float)this.pageData.getCropBoxX(this.pageNumber) * this.scaling;
        double d2 = (float)this.pageData.getCropBoxY(this.pageNumber) * this.scaling;
        double d3 = (float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling;
        double d4 = (float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling;
        double d5 = (float)this.pageData.getMediaBoxX(this.pageNumber) * this.scaling;
        double d6 = (float)this.pageData.getMediaBoxY(this.pageNumber) * this.scaling;
        double d7 = (float)this.pageData.getMediaBoxWidth(this.pageNumber) * this.scaling;
        double d8 = (float)this.pageData.getMediaBoxHeight(this.pageNumber) * this.scaling;
        int n = (int)((double)this.insetW + d);
        int n2 = (int)((double)this.insetH + d8 - d4 - d2);
        int n3 = (int)d3;
        int n4 = (int)d4;
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
            n5 = n;
            n = n2;
            n2 = n5;
        }
        graphics2D.translate(this.insetW - n, this.insetH - n2);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (!this.showCrop) {
            graphics2D.clip(new Rectangle(n, n2, n3, n4));
        }
        if (this.displayScaling != null) {
            graphics2D.transform(this.displayScaling);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            if (this.useAcceleration && !this.overRideAcceleration) {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("acceleration called ");
                }
                if (this.backBuffer == null) {
                    this.createBackBuffer();
                }
                if (this.backBuffer != null) {
                    do {
                        Object object;
                        int n6;
                        if ((n6 = this.backBuffer.validate(this.getGraphicsConfiguration())) != 1 && n6 == 2) {
                            this.createBackBuffer();
                        }
                        if (this.screenNeedsRedrawing && this.backBuffer != null) {
                            this.screenNeedsRedrawing = false;
                            object = (Graphics2D)this.backBuffer.getGraphics();
                            ((Graphics)object).setColor(Color.white);
                            ((Graphics2D)object).fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                            ((Graphics2D)object).setTransform(this.displayScaling);
                            float f = (float)n / this.scaling;
                            float f2 = (float)n2 / this.scaling;
                            if (this.rotation == 0) {
                                ((Graphics2D)object).translate(-f, f2);
                            } else if (this.rotation == 90) {
                                ((Graphics2D)object).translate(-f2, -f);
                            } else if (this.rotation == 180) {
                                ((Graphics2D)object).translate(f, -f2);
                            } else if (this.rotation == 270) {
                                ((Graphics2D)object).translate(f2, f);
                            }
                            rectangle = this.currentDisplay.paint((Graphics2D)object, null, this.viewScaling);
                            ((Graphics)object).dispose();
                        }
                        object = graphics2D.getTransform();
                        graphics2D.setTransform(affineTransform2);
                        graphics2D.translate(n, n2);
                        graphics2D.drawImage(this.backBuffer, 0, 0, this);
                        graphics2D.setTransform((AffineTransform)object);
                    } while (this.backBuffer.contentsLost());
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                rectangle = this.currentDisplay.paint(graphics2D, this.areas, this.viewScaling);
            }
            if (this.currentHighlightedObject == null && this.lastHighlight != null) {
                this.lastHighlight = null;
            }
            AffineTransform affineTransform3 = graphics2D.getTransform();
            if (this.viewScaling != null) {
                graphics2D.transform(this.viewScaling);
            }
            if (this.highlightedZonesSelected != null) {
                this.paintHighlights(graphics2D);
            }
            if (this.displayHotspots != null) {
                this.displayHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, this.pageNumber);
            }
            if (this.merge_level != null && this.showMerging) {
                this.paintMergingInfo(graphics2D);
            }
            if (this.cursorBoxOnScreen != null) {
                this.paintRectangle(graphics2D, rectangle);
            }
            graphics2D.setTransform(affineTransform2);
            if (this.currentHighlightedObject != null) {
                graphics2D.setColor(this.outlineHighlightColor);
                graphics2D.draw(this.currentHighlightedObject);
            }
            graphics2D.setClip(shape);
            if (this.showCrop) {
                graphics2D.setColor(Color.orange);
                graphics2D.drawLine(n, n2, n + n3, n2 + n4);
                graphics2D.drawLine(n, n2 + n4, n + n3, n2);
            }
            if (n3 > 0 && n4 > 0 && this.myBorder != null) {
                this.myBorder.paintBorder(this, graphics2D, n - 1, n2 - 1, n3 + 2, n4 + 2);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    private void paintMergingInfo(Graphics2D graphics2D) {
        int n = this.merge_outline.size() - 1;
        for (int i = 0; i < n; ++i) {
            Area area = this.merge_outline.elementAt(i);
            int n2 = this.merge_level.elementAt(i);
            if (!(this.showDebugLevel[n2] & area != null)) continue;
            graphics2D.setColor(this.debugColors[n2]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.draw(area.getBounds());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(area);
        }
    }

    public void setDrawCrossHairs(boolean bl) {
        this.drawCrossHairs = bl;
    }

    private void paintRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics2D.setColor(this.outlineColor);
        graphics2D.draw(this.cursorBoxOnScreen);
        if (this.drawCrossHairs) {
            int n5 = this.cursorBoxOnScreen.x;
            n4 = this.cursorBoxOnScreen.y;
            n3 = n5 + this.cursorBoxOnScreen.width;
            n2 = n4 + this.cursorBoxOnScreen.height;
            n = this.pageData.getCropBoxWidth(this.pageNumber);
            int n6 = this.pageData.getMediaBoxHeight(this.pageNumber);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f));
            graphics2D.drawLine(n5, n4, 0, n4);
            graphics2D.drawLine(n5, n4, n5, 0);
            graphics2D.drawLine(n3, n4, n, n4);
            graphics2D.drawLine(n3, n4, n3, 0);
            graphics2D.drawLine(n5, n2, 0, n2);
            graphics2D.drawLine(n5, n2, n5, n6);
            graphics2D.drawLine(n3, n2, n, n2);
            graphics2D.drawLine(n3, n2, n3, n6);
            graphics2D.setStroke(stroke);
            graphics2D.drawRect(n5 - 5, n4 + Math.abs(n2 - n4) / 2 - 5, 10, 10);
            graphics2D.drawRect(n5 + Math.abs(n3 - n5) / 2 - 5, n4 - 5, 10, 10);
            graphics2D.drawRect(n5 + Math.abs(n3 - n5) / 2 - 5, n2 - 5, 10, 10);
            graphics2D.drawRect(n3 - 5, n4 + Math.abs(n2 - n4) / 2 - 5, 10, 10);
            graphics2D.drawRect(n5 - 5, n4 - 5, 10, 10);
            graphics2D.drawRect(n5 - 5, n2 - 5, 10, 10);
            graphics2D.drawRect(n3 - 5, n4 - 5, 10, 10);
            graphics2D.drawRect(n3 - 5, n2 - 5, 10, 10);
        }
        if (rectangle == null) {
            this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
        } else {
            Rectangle rectangle2 = this.cursorBoxOnScreen.getBounds();
            n4 = (int)rectangle2.getMinX();
            n3 = (int)rectangle2.getMinY();
            n2 = (int)rectangle2.getMaxX();
            n = (int)rectangle2.getMaxY();
            Rectangle rectangle3 = rectangle.getBounds();
            int n7 = (int)rectangle3.getMinX();
            if (n7 < n4) {
                n4 = n7;
            }
            if ((n7 = (int)rectangle3.getMinY()) < n3) {
                n3 = n7;
            }
            if ((n7 = (int)rectangle3.getMaxX()) > n2) {
                n2 = n7;
            }
            if ((n7 = (int)rectangle3.getMaxY()) > n) {
                n = n7;
            }
            this.lastCursorBoxOnScreen = new Rectangle(n4 - 5, n3 - 5, 10 + n2 - n4, 10 + (n - n3));
        }
    }

    private void paintHighlights(Graphics2D graphics2D) {
        int n = this.highlightedZonesSelected.length;
        for (int i = 0; i < n; ++i) {
            if (this.highlightedZonesSelected[i]) {
                this.highlightStoryOnscreen(graphics2D, i);
                continue;
            }
            if ((this.highlightMode & 1) != 1) continue;
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            if (this.highlightColors[i] == null) {
                graphics2D.setColor(Color.darkGray);
            } else {
                graphics2D.setColor(this.highlightColors[i]);
            }
            graphics2D.fill(this.fragmentShapes[i]);
            graphics2D.draw(this.outlineZone[i]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics2D.draw(this.outlineZone[i]);
            int[] nArray = (int[])this.linkedItems[i];
            if (nArray == null) continue;
            this.numberItems(false, graphics2D, i + "-", nArray);
        }
        if (this.pageLines != null && (this.highlightMode & 2) == 2) {
            this.pageLines.drawLines(graphics2D);
        }
        if (this.selectionOrder != null) {
            this.numberItems(false, graphics2D, "", this.selectionOrder);
        }
    }

    private void highlightStoryOnscreen(Graphics2D graphics2D, int n) {
        if (this.highlightColors[n] == null) {
            graphics2D.setColor(Color.blue);
        } else {
            graphics2D.setColor(this.highlightColors[n]);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
        graphics2D.fill(this.fragmentShapes[n]);
        graphics2D.draw(this.outlineZone[n]);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
        graphics2D.draw(this.outlineZone[n]);
        int n2 = this.outlineZone[n].getBounds().x;
        int n3 = this.outlineZone[n].getBounds().y;
        graphics2D.drawLine(n2, n3 + (int)this.outlineZone[n].getBounds().getHeight(), n2 + (int)this.outlineZone[n].getBounds().getWidth(), n3);
        int[] nArray = (int[])this.linkedItems[n];
        if (nArray != null) {
            int n4 = nArray.length;
            for (int i = 1; i < n4; ++i) {
                if (nArray[i] == -1) continue;
                this.highlightStoryOnscreen(graphics2D, nArray[i]);
            }
        }
    }

    private void numberItems(boolean bl, Graphics2D graphics2D, String string, int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n4 == -1) {
                i = n;
                continue;
            }
            String string2 = string + "" + n3;
            int[] nArray2 = (int[])this.linkedItems[n4];
            if (nArray2 != null) {
                ++n3;
                int n5 = nArray2.length;
                int n6 = 0;
                for (int j = 0; j < n5; ++j) {
                    int n7 = nArray2[j];
                    ++n6;
                    if (n7 == -1) {
                        j = n5;
                        continue;
                    }
                    this.numberItem(graphics2D, n7, string2 + "." + n6);
                }
                continue;
            }
            if (this.parents[n4] != -1) continue;
            this.numberItem(graphics2D, n4, string2);
            ++n3;
        }
    }

    private void numberItem(Graphics2D graphics2D, int n, String string) {
        AffineTransform affineTransform = new AffineTransform();
        GlyphVector glyphVector = this.highlightFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(this.cx[n], -this.cy[n]);
        Area area = new Area(glyphVector.getOutline());
        area.transform(affineTransform);
        graphics2D.setColor(Color.black);
        graphics2D.fill(area.getBounds());
        graphics2D.setColor(Color.white);
        graphics2D.fill(area);
    }

    public void flagNumbersForRedraw(int n) {
        if (this.selectionOrder != null && this.cx != null && this.cy != null) {
            for (int i = 0; i < this.selectionOrder.length; ++i) {
                int n2 = this.selectionOrder[i];
                if (n2 == -1) {
                    i = this.selectionOrder.length;
                    continue;
                }
                this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n2] * this.scaling), (int)((float)(n - this.cy[n2] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                int[] nArray = (int[])this.linkedItems[n2];
                if (nArray == null) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    if (n3 == -1) {
                        j = nArray.length;
                        continue;
                    }
                    this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n3] * this.scaling), (int)((float)(n - this.cy[n3] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                }
            }
        }
    }

    public final int getPDFWidth() {
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getRawPDFWidth() {
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            return this.y_size;
        }
        return this.x_size;
    }

    public final int getPDFHeight() {
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final int getRawPDFHeight() {
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            return this.x_size;
        }
        return this.y_size;
    }

    public Rectangle[] getPageHotspots() {
        return this.displayHotspots.getAnnotationhotSpots();
    }

    public void disableBorderForPrinting() {
        this.useBorder = false;
    }

    public final void setPDFBorder(Border border) {
        this.myBorder = border;
        this.useBorder = true;
    }

    protected final AffineTransform getScalingForImage(int n, int n2, int n3, float f) {
        double d;
        AffineTransform affineTransform = new AffineTransform();
        if (n == 270) {
            affineTransform.rotate(-1.5707963267948966, n2 / 2, n3 / 2);
            d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.translate((double)n3 - d2, -d);
        } else if (n == 180) {
            affineTransform.rotate(Math.PI, n2 / 2, n3 / 2);
        } else if (n == 90) {
            affineTransform.rotate(1.5707963267948966, n2 / 2, n3 / 2);
            d = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate(-d3, (double)n2 - d);
        }
        affineTransform.translate(n2, n3);
        affineTransform.scale(1.0, -1.0);
        int n4 = this.pageData.getMediaBoxX(this.pageNumber);
        int n5 = this.pageData.getMediaBoxY(this.pageNumber);
        affineTransform.translate((float)(-n2) - (float)n4 * f, -((float)n5 * f));
        affineTransform.scale(f, f);
        return affineTransform;
    }

    public final void setPageRotation(int n) {
        double d;
        double d2;
        this.screenNeedsRedrawing = true;
        this.backBuffer = null;
        this.raw_rotation = n;
        double d3 = (float)this.pageData.getMediaBoxX(this.pageNumber) * this.scaling;
        double d4 = (float)this.pageData.getMediaBoxY(this.pageNumber) * this.scaling;
        double d5 = (float)this.pageData.getMediaBoxWidth(this.pageNumber) * this.scaling;
        double d6 = (float)this.pageData.getMediaBoxHeight(this.pageNumber) * this.scaling;
        double d7 = (float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling;
        double d8 = (float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling;
        double d9 = (float)this.pageData.getCropBoxX(this.pageNumber) * this.scaling;
        double d10 = (float)this.pageData.getCropBoxY(this.pageNumber) * this.scaling;
        this.displayScaling = new AffineTransform();
        int n2 = (int)(d7 + (d9 - d3));
        int n3 = (int)(d8 + (d10 - d4));
        if (this.raw_rotation == 270) {
            this.displayScaling.rotate(-1.5707963267948966, n2 / 2, n3 / 2);
            d2 = this.displayScaling.getTranslateX();
            d = this.displayScaling.getTranslateY();
            this.displayScaling.translate((double)n3 - d, -d2);
            this.displayScaling.translate(0.0, n3);
            this.displayScaling.scale(1.0, -1.0);
            this.displayScaling.translate(-(d9 + d3), -(d6 - d8 - (d10 - d4)));
        } else if (this.raw_rotation == 180) {
            this.displayScaling.rotate(Math.PI, n2 / 2, n3 / 2);
            this.displayScaling.translate(-(d9 + d3), (double)n3 + (d10 + d4) - (d6 - d8 - (d10 - d4)));
            this.displayScaling.scale(1.0, -1.0);
        } else if (this.raw_rotation == 90) {
            this.displayScaling.rotate(1.5707963267948966);
            this.displayScaling.translate(0.0, d10 + d4 - (d6 - d8 - (d10 - d4)));
            this.displayScaling.scale(1.0, -1.0);
        } else {
            this.displayScaling.translate(0.0, n3);
            this.displayScaling.scale(1.0, -1.0);
            this.displayScaling.translate(0.0, -(d6 - d8 - (d10 - d4)));
        }
        this.displayScaling.scale(this.scaling, this.scaling);
        if (this.raw_rotation == 90) {
            this.displayScaling.translate((float)this.insetH / this.scaling, (float)this.insetW / this.scaling);
        } else if (this.raw_rotation == 270) {
            this.displayScaling.translate((float)(-this.insetH) / this.scaling, (float)(-this.insetW) / this.scaling);
        } else if (this.raw_rotation == 180) {
            this.displayScaling.translate((float)(-this.insetW) / this.scaling, (float)this.insetH / this.scaling);
        } else {
            this.displayScaling.translate((float)this.insetW / this.scaling, (float)(-this.insetH) / this.scaling);
        }
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            d2 = (double)this.viewableArea.width / (double)this.pageData.getCropBoxWidth(this.pageNumber);
            d = (double)this.viewableArea.height / (double)this.pageData.getCropBoxHeight(this.pageNumber);
            double d11 = d2;
            if (d < d2) {
                d11 = d;
            }
            int n4 = this.viewableArea.x;
            int n5 = this.viewableArea.y;
            this.viewScaling.translate(n4, n5);
            this.viewScaling.scale(d11, d11);
        } else {
            this.viewScaling = null;
        }
    }

    public final void setPageParameters(float f, int n, int n2) {
        this.drawRotatedPage = true;
        this.rotation = n2;
        this.setPageParameters(f, n);
    }

    public final void setPageParameters(float f, int n) {
        this.overRideAcceleration = false;
        this.pageNumber = n;
        this.scaling = f;
        int n2 = this.pageData.getMediaBoxWidth(n);
        this.max_y = this.pageData.getMediaBoxHeight(n);
        int n3 = this.pageData.getMediaBoxX(n);
        int n4 = this.pageData.getMediaBoxY(n);
        int n5 = this.volatileWidth = this.pageData.getCropBoxWidth(n);
        int n6 = this.volatileHeight = this.pageData.getCropBoxHeight(n);
        int n7 = this.pageData.getCropBoxX(n);
        int n8 = this.pageData.getCropBoxY(n);
        this.x_size_cropped = (int)((float)n5 * f);
        this.y_size_cropped = (int)((float)n6 * f);
        this.x_size = (int)((float)n5 * f);
        this.y_size = (int)((float)n6 * f);
        if (!this.drawRotatedPage) {
            this.rotation = this.pageData.getRotation(n);
        } else {
            this.drawRotatedPage = false;
        }
        this.currentDisplay.init(n2, this.max_y, this.rotation);
        this.setPageRotation(this.rotation);
    }

    protected final AffineTransform setPageParametersForImage(float f, int n) {
        AffineTransform affineTransform = new AffineTransform();
        int n2 = this.pageData.getMediaBoxWidth(n);
        int n3 = this.pageData.getMediaBoxHeight(n);
        int n4 = this.pageData.getMediaBoxX(n);
        int n5 = this.pageData.getMediaBoxY(n);
        int n6 = this.pageData.getCropBoxWidth(n);
        int n7 = this.pageData.getCropBoxHeight(n);
        int n8 = this.pageData.getCropBoxX(n);
        int n9 = this.pageData.getCropBoxY(n);
        if (this.raw_rotation == 90 | this.raw_rotation == 270) {
            int n10 = n6;
            n6 = n7;
            n7 = n10;
        }
        double d = f;
        int n11 = (int)((float)n6 * f);
        int n12 = (int)((float)n7 * f);
        int n13 = this.pageData.getRotation(n);
        affineTransform.translate((float)(-n8) * f, (float)n9 * f);
        if (n13 == 270) {
            affineTransform.rotate(-1.5707963267948966, n11 / 2, n12 / 2);
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate((double)n12 - d3, -d2);
        } else if (n13 == 180) {
            affineTransform.rotate(Math.PI, n11 / 2, n12 / 2);
        } else if (n13 == 90) {
            affineTransform.rotate(1.5707963267948966, n11 / 2, n12 / 2);
            double d4 = affineTransform.getTranslateX();
            double d5 = affineTransform.getTranslateY();
            affineTransform.translate(-d5, (double)n11 - d4);
        }
        if (d < 1.0) {
            affineTransform.translate(n11, n12);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n11, 0.0);
            affineTransform.scale(d, d);
        } else {
            affineTransform.translate(n11, n12);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n11, 0.0);
            affineTransform.scale(f, f);
        }
        return affineTransform;
    }

    public void setHardwareAccelerationforScreen(boolean bl) {
        this.useAcceleration = bl;
    }
}

