#ifndef __MXVIEW_H__
#define __MXVIEW_H__

/**
 * File Name  : template.h
 *
 * Description: 
 */

/*
 * This file is part of mxSudoku
 *
 * mxSudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxSudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gtk/gtk.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

// BACKGROUND: The goal is to support more types of games that are simular to sudoku
//             like kakuro or jigoku. For now I settle for 3x3 sudoku

// The list of the type of views that are supported
// mxview_keypad: have a board and keypad
typedef enum _mxview_type {
	mxview_keypad = 0
} mxview_type, *p_mxview_type;

// game info
// TODO: when more views are supported, the parameters in the structure can better be
//       changed into an enum of structures. One structure for a specific view
typedef struct _mxview_game {
	mxview_type     type;
	int             board_horizontal;
	int             board_vertical;
	int             keypad_nr_symbols; // the clear/verify/cheat symbols will automatically be added
} mxview_game, *p_mxview_game;
//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global Variables
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================
// TODO: Doxygen

// create a new view for the game
GtkWidget *mxview_create(p_mxview_game game);

// refresh the screen
void mxview_update();

// show status message on screen
void mxview_status_msg(char *msg);

// update the value of a cell of the board
// flags: 1=readonly, 0=normal
void mxview_cell_set_value(int cell_nr, int value, int flags);

G_END_DECLS

#endif /* __MXVIEW_H__ */
