#ifndef __LOG_H__
#define __LOG_H__

/**
 * File Name  : log.h
 *
 * Description: Macros for debug printing
 *
 * The value of ERREGLOG_X_ON (with X one of LOGGING, WARNING or ERROR)
 * determines whether a message will be printed. The value as defined
 * in this file can be overruled by defining them before the inclusion of this file.
 *
 * This file is best included in c files only.
 */

/*
 * This file is part of hello_world.
 *
 * hello_world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello_world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */


#define LOG_PREFIX  PACKAGE


#ifndef LOGGING_ON
#define LOGGING_ON 1
#endif

#ifndef WARNING_ON
#define WARNING_ON 1
#endif

#ifndef ERROR_ON
#define ERROR_ON 1
#endif

extern FILE *fplog;

#define LOGINIT(name) fplog = fopen(name, "w");

#if (LOGGING_ON)
#define LOGPRINTF(format, args...) fprintf(fplog, "(" LOG_PREFIX "_L)" __FILE__ ":%d,%s() " format "\n", __LINE__, __func__ , ##args)
#else
#define LOGPRINTF(format, args...) do {} while (0)
#endif

#if (WARNING_ON)
#define WARNPRINTF(format, args...) fprintf(fplog, "(" LOG_PREFIX "_W)" __FILE__ ":%d,%s() " format "\n", __LINE__, __func__ , ##args)
#else
#define WARNPRINTF(format, args...) do {} while (0)
#endif

#if (ERROR_ON)
#include <errno.h>
#include <string.h>
#define ERRORPRINTF(format, args...) fprintf(fplog, "(" LOG_PREFIX "_E)" __FILE__ ":%d,%s() --- " format "\n", __LINE__, __func__ , ##args)
#define ERRNOPRINTF(format, args...) fprintf(fplog, "(" LOG_PREFIX "_E)" __FILE__ ":%d,%s() --- " format ", errno [%d] [%s]\n", __LINE__, __func__ , ##args, errno, strerror(errno))
#else
#define ERRORPRINTF(format, args...) do {} while (0)
#define ERRNOPRINTF(format, args...) do {} while (0)
#endif


#endif // __LOG_H__
