#!/usr/bin/env lua
-- hans@hpelbers.org, march 2009

require("lgob.gtk")

-- Start of App --
local app={}		-- Aplication data
local units = {
  {unit='meters', scale=1},
  {unit='milimeters', scale=0.001},
  {unit='kilometers', scale=1000}, 
  {unit='yards', scale=0.9144},
  {unit='inches', scale=0.0254},
  {unit='miles', scale=1609.344},
  {unit='feet', scale=0.3048},
  {unit='nautical miles', scale=1852},
}


-- This function is called when apply is pressed
local function doApply(r) 
  local text = r.entry:get_text()
  val = tonumber(text) or 0	-- catch non numeric entries
  val = val * r.toMeter 	-- entered value converted to meter

  -- update all fields
  for i, row in ipairs(app) do
    local newVal = val / row.toMeter
    row.entry:set_text(string.format("%G", newVal))
  end
end

local function doQuit() 
  gtk.main_quit()
end

-- contruct the gui...
local window    = gtk.Window.new()
local vbox      = gtk.VBox.new(false, 5)
local table     = gtk.Table.new(#units,8)

local quit = gtk.Button.new()
quit:set('label', 'QUIT')
quit:connect('clicked', doQuit)

window:add(vbox)
vbox:pack_start(quit, false)
vbox:pack_start(table, false)
local info = gtk.Label.new()
info:set_text("Just enter some value\nHit 'Convert!'\nand enjoy the results")
vbox:pack_start(info, true)

for i, item in ipairs(units) do
  local row = {}
  app[i]= row	    -- apllication data for this row

  row.toMeter = item.scale

  local label   = gtk.Label.new()
  label:set('label', item.unit)

  row.entry = gtk.Entry.new()
  row.entry:connect('activate', doApply, row)	-- <enter> in entry

  local apply = gtk.Button.new()
  apply:set('label', 'Convert!')
  apply:connect('clicked', doApply, row)

  local b,w = 0,0 
  w=2; table:attach_defaults(label,   b, b+w, i-1,i); b = b+w
  w=4; table:attach_defaults(row.entry, b, b+w, i-1,i); b = b+w
  w=2; table:attach_defaults(apply,   b, b+w, i-1,i); b = b+w
end

window:connect("delete-event", gtk.main_quit)
window:show_all()

gtk.main()
