#ifndef __MXGRID_H__
#define __MXGRID_H__

/**
 * File Name  : mxGrid.h
 *
 * Description: Implement initial version of a 'grid' widget.
 */

/*
 * This file is part of mxSudoku
 *
 * mxSudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxSudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gtk/gtk.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

#define GTK_GRID_TYPE            (gtk_grid_get_type())
#define GTK_GRID(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_GRID_TYPE, GtkGrid))
#define GTK_GRID_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_GRID_TYPE, GtkGridClass))
#define IS_GTK_GRID(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_GRID_TYPE))
#define IS_GTK_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_GRID_TYPE))

//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------

typedef struct _GtkGrid       GtkGrid;
typedef struct _GtkGridClass GtkGridClass;

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

typedef struct _mxGridEvent_t
{
	// the grid
	GtkGrid *grid;
	// event parameters
	int cell_nr;		// This cell was clicked	
	int x;              // the position of the cell in the grid
	int y;
} mxGridEvent_t, *p_mxGridEvent_t;

//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

// The FIT-MODES:
#define MXGRID_CONFIG_FIT_CENTRE	(0x00000000)
#define MXGRID_CONFIG_FIT_FULL      (0x00000001)
#define MXGRID_CONFIG_FIT_PREFERRED (0x00000002)
#define MXGRID_CONFIG_FIT_SQUARE    (0x00000004)
//----------------------------------------------------------------------------
// Global Variables
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================
// TODO: Doxygen

// Create a new Grid-widget
GtkWidget * gtk_grid_new(void);

// Get the type of the gtk grid widget
GType gtk_grid_get_type(void);

// Set the preferred nr of cells horizontal and vertical
void gtk_grid_set_size(GtkGrid *grid, int horizontal, int vertical);

// set the preferred 'inner' size for the cells. Mode determines how
// to react to automatic mode (w=h=0).
// 0: use max size for both direction
// 1: use min of max sizes, to get square sizes
// TODO: create define or enum to use for mode
void gtk_grid_set_preferred_size(GtkGrid *grid, int w, int h, int mode);

// set ornaments for the grid
void gtk_grid_set_ornaments(GtkGrid *grid, int size, char **pp_ornaments);
							
// set the fg_color of a specific cell
void gtk_grid_set_cell_fg_color(GtkGrid *grid, int nr, GdkColor color);

// set the bg_color of a specific cell
void gtk_grid_set_cell_bg_color(GtkGrid *grid, int nr, GdkColor color);

// set the text for a cell
void gtk_grid_set_cell_text(GtkGrid *grid, int nr, char *text);

G_END_DECLS

#endif /* __MXGRID_H__ */
