#!/bin/bash

echo ""
echo ""
echo "Work directory = " `pwd`
echo ""
echo "E-reader filesystem = " $EREADER_ROOT
echo "-------------------"
echo ""


set_environment()
{
    if [ "$PKG_CONFIG_SYSROOT_DIR" = "" ]
    then
        echo "-- Host compilation"
        DESTDIR="/"
    else
        echo "-- Cross compilation"
        CONFIGURE_OPTIONS="--host=arm-poky-linux-gnueabi --sysconfdir=/etc --prefix=/usr"
        DESTDIR="/usr/local/poky/eabi-glibc/arm/arm-poky-linux-gnueabi"
    fi
    export DESTDIR
}

set -e  # stop on error
set -v  # verbose
##set -x  # show executed commands


# Install build environment
set_environment
autoreconf --install --force
./configure ${CONFIGURE_OPTIONS} $*


# Build new object files
make clean
make

# Generate language files
cd po
rm -f *.gmo
make update-po
make update-gmo
cd ..

# Install new object and data files
if [ "$PKG_CONFIG_SYSROOT_DIR" != ""  -a  "$EREADER_ROOT" != "" ]
then
    make install DESTDIR="$EREADER_ROOT"
fi


echo "Done ok"

