#!/usr/bin/perl -w
#
# Author: Sebastian Scherer, basti@andrew.cmu.edu
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.


use File::Copy;
use DBI;
use strict;

# Sony Reader paths:
my $cardpath = "/Volumes/EBOOKS16GB";
my $internalpath = "/Volumes/PRS700";
my $cardbookpath = $cardpath;

# Paths to your ebooks from Papers:
my $pdfpath =  "/Users/basti/Documents/Papers";
my $paperslibrary = "dbi:SQLite:$pdfpath/Library.papers";
# Path to a general folder with ebooks:
my $bookpath =  "/Users/basti/Documents/eBooks/eBooks";


# Paths to necessary executables
my $rsyncpath = "/usr/bin/rsync"; #Could also use /usr/bin/rsync
my $rsyncargs = "-a --delete --modify-window=3601";
my $pdftkpath = "/sw/bin/pdftk";


my $tmpbookpath = "/tmp/tmpbook.pdf";

# No modifcation below this line should be necessary
#-------------------------------------------------------

if(-d $cardpath)
  {
    print "Have the card directory\n";
  }else
  {
    die "Card directory does not exist. Exiting\n";
  }
if(-e "$cardpath/.running")
  {
    die "Already running\n";
  }
#have a race condition here:"
system("touch $cardpath/.running");


my $dbh = DBI->connect($paperslibrary) || die " Cannot connect: $DBI::errstr";
#other good fields:
# zrating
# zcategory 
# ztitle
# znotes
# zlabel
# zabstract
# zdoi
# 

my $allbookstoconvertandadd = "SELECT zlastreaddate,zrating,zflagged,znotes,ztitle,zabstract,zpath FROM ZPAPER WHERE Z_PK IN (SELECT Z_11PAPERS2 FROM Z_3PAPERS WHERE Z_3GROUPS IN (SELECT Z_PK FROM ZGROUP WHERE ZNAME=?));";
my $allbq = $dbh->prepare($allbookstoconvertandadd);
my $query = "SELECT  zlastreaddate,zrating,zflagged,znotes,ztitle,zabstract FROM zpaper WHERE zpath=?";
my $sth = $dbh->prepare($query);

my $authorquery = "SELECT ZAUTHOR FROM ZORDEREDAUTHOR WHERE ZPAPER IN (SELECT Z_PK FROM ZPAPER WHERE zpath=?) ORDER BY ZORDER ASC;";
my $aqp = $dbh->prepare($authorquery);
my $authornamequery ="SELECT zfirstname,zlastname FROM ZAUTHOR WHERE Z_PK=?"; 
my $anq = $dbh->prepare($authornamequery);
sub updatemetadata
  {
    my ($eachFile) = @_;
#print "asdf: $eachFile\n";
    if($eachFile =~ /.(pdf|djvu|cbz)/)
      {
	  my $author = "Unknown";
	  my $title = "Unknown";
	  #$eachFile =~ s/\p{^InBasic_Latin}/\*/g;
	  if($eachFile =~ /.*\/(.*)\/(.*).(pdf|djvu|cbz)/)
	    {
	      $author = $1;
	      $title =$2;
	      
	      my $querykey= "$author/$title.pdf";
	      #print "querykey: $querykey\n";
	      $aqp->execute($querykey) or die "Could not execute statement: $aqp->errstr\n";
	      
	      my @authors;

	      my $authora="";
	      while(@authors = $aqp->fetchrow_array())
		{
		 # print "ahu: ".$authors[0]."\n";

		  $anq->execute($authors[0]);
		  
		  my @autname =  $anq->fetchrow_array();
		  
		  $anq->finish;
		  my $fullname = join(" ",@autname);
		  my @list = ($authora,$fullname);
		  if(length($authora)>0)
		    {
		      $authora = join(", ",@list);
		    }else
		      {		
			$authora = $fullname;
		      }
		}
	      if(length($authora)==0)
		{
		  $authora = $author;
		}
	      #print "Name: $authora\n";
	      $aqp->finish;
	      $sth->execute($querykey) or die "Could not execute statement: $sth->errstr\n";
	      my @data = $sth->fetchrow_array();
	      $sth->finish;
	      my $rr = $data[0];
	      my $readpaper =1 ;
	      $readpaper = 0 unless defined $rr;
	      $readpaper = 0;
	      my $rating = $data[1];
	      $rating = 0 unless defined $rating;
	      my $flagged = $data[2];
	      $flagged = 0 unless defined $flagged;
	      my $notes = $data[3];
	      $notes = "" unless defined $notes;
	      my $titlea = $data[4];
	      $titlea = $title unless defined $titlea;
	      my $abstract = $data[5];
	      $abstract = "" unless defined $abstract;
	      #$abstract = substr($abstract,0,254);
	      # now create a file with the meta data:
	      open(FILE,">/tmp/metadata.txt") or die "Was not able to open metadatafile";
	      my $infofile = "InfoKey: Title\nInfoValue: $titlea\nInfoKey: Author\nInfoValue: $authora\nInfoKey: Subject\nInfoValue: $abstract\nInfoKey: Keywords\nInfoValue: $notes\n";
	      #print $infofile;
	      print FILE $infofile;
	      close(FILE);
	      my $command="$pdftkpath \"$eachFile\" update_info /tmp/metadata.txt output \"$tmpbookpath\"";
	      #print "$command\n";
	      my $res = system($command);
	      if($res==0)
		{
		  #unlink($eachFile);
		  move($tmpbookpath,$eachFile);
		  print "Updated successfully \"$titlea\", $authora\n";
		}else
		  {
		    print "Error not overwriting file: $res\n";
		  }
	    }else
	      {
	      print "Could not parse names\n";
	    }
      }

  }



sub recurse {
  my($path) = @_;
 
  ## append a trailing / if it's not there
  $path .= '/' if($path !~ /\/$/);

  ## print the directory being searched
  #xsprint $path,"\n";

  ## loop through the files contained in the directory
  for my $eachFile (glob($path.'*')) {

    ## if the file is a directory
    if( -d $eachFile) {
      ## pass the directory to the routine ( recursion )
      recurse($eachFile);
    } else {
      updatemetadata($eachFile);
    }
  }
}

my %filehash = ();
sub recurseOnlyUpdated {
  
  my($path) = @_;
  
  ## append a trailing / if it's not there
  $path .= '/' if($path !~ /\/$/);

  ## print the directory being searched
  #xsprint $path,"\n";
  ## loop through the files contained in the directory
  for my $eachFile (glob($path.'*')) {

    ## if the file is a directory
    if( -d $eachFile) {
      ## pass the directory to the routine ( recursion )
      recurseOnlyUpdated($eachFile);
    } else {
      my $efb = $eachFile;
      chomp($eachFile);
      $eachFile =~ s/\n//g;
      $eachFile =~ s/\r//g;
      print FILENEW "$eachFile\n";
      if (exists $filehash{$eachFile}) 
	{
	 # print "Already updated metadata for $eachFile\n";
	}
      else
	{
	  print "UPDATING metadata for $eachFile\n";
	  updatemetadata($efb);
	}   
    }
  }
}

sub recOnlyUpWrap {
 print "Reading in processed files\n";
  my $fname = "/Users/basti/.bin/visited.txt";
  system("touch $fname");
  open(FILE,$fname) or die " was not able to open $fname\n";
 
  while(<FILE>)
    {
      chomp($_);
      
      $filehash{$_} = 1;
    }
  close(FILE);
  open(FILENEW,">$fname.new");
 recurseOnlyUpdated(@_);
 close(FILENEW);
 move("$fname.new",$fname);
}

print "Adding meta data to papers\n";
recOnlyUpWrap($pdfpath);
print "done\n\n";
$dbh->disconnect;
print "Synching SD card and eBook folder\n";

system("$rsyncpath $rsyncargs $bookpath $cardbookpath");
print "Synching SD card and papers folder\n";
system("$rsyncpath $rsyncargs $pdfpath $cardpath");
print "done\n\n";
unlink("$cardpath/.running");
print "unmounting the ebook volume\n";
system("diskutil unmount $cardpath");
system("diskutil unmount $internalpath");
