#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
kommersant.ru
'''

from calibre.web.feeds.news import BasicNewsRecipe

class Kommersant(BasicNewsRecipe):
    title                 = 'Kommersant'
    __author__            = 'Darko Miletic'
    description           = u'Ежедневная иллюстрированная общенациональная деловая газета'
    publisher             = u'Коммерсантъ'
    category              = u'news, russia'    
    language              = _('Russian')
    oldest_article        = 1
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'cp1251'
    remove_javascript     = True
    use_embedded_content  = False
    extra_css = '@font-face {font-family: "serif0";src:url(res:///Data/FONT/serif0.ttf)} @font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif0, serif1, serif} .article_description{font-family: serif0, serif1, serif} a.article{font-family: serif0, serif1, serif}'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 
     
    keep_only_tags = [
                     dict(name='span', attrs={'id':['ctl00_ContentPlaceHolderStyle_LabelTitle','ctl00_ContentPlaceHolderStyle_LabelSubTitle']})
                    ,dict(name='span', attrs={'class':['vvodka','paragraph']})
                    ,dict(name='div', attrs={'class':'author'})
                  ]

    remove_tags = [dict(name=['link','base'])]

                  
    feeds = [(u'Газета "Коммерсантъ". Полная версия', u'http://www.kommersant.ru/RSS_Export/RU/daily.xml')]

    def preprocess_html(self, soup):
        for item in soup.findAll('span'):
            if item.has_key('id'):
               if item['id'] == 'ctl00_ContentPlaceHolderStyle_LabelTitle':
                  item.name = 'h1'
               if item['id'] == 'ctl00_ContentPlaceHolderStyle_LabelSubTitle':
                  item.name = 'h3'            
            else:
                item.insert(1,'<br /><br />')
        return soup
