#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir


FILESIZE=$(ls -l /usr/lib/libpoppler.so.1.0.0 | awk '{print $5}')

if [ $FILESIZE = "1529052" ] 
then
  CURRENT="henryhu's updated poppler"
elif [ $FILESIZE = "1524964" ] 
then
  CURRENT="iRex's official poppler"
else
  CURRENT="a new unrecognised"
fi


cat <<EOF > manifest.xml
<?xml version="1.0" encoding="utf-8"?>
<package>
  <metadata>
    <dc-metadata>
      <Title>Run me to identify the poppler version</Title>
      <Description>This looks like $CURRENT version</Description>
      <Date>2009-03-01T10:54:28</Date>
      <Identifier/>
      <Language/>
      <Type/>
    </dc-metadata>
    <y-metadata>
      <startpage>run.sh</startpage>
      <image>question_mark.jpeg</image>
      <version>001</version>
    <ItemSize>2998</ItemSize></y-metadata>
  </metadata>
</package>
EOF
