#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
Firmware_iLiad=`cat /etc/er_version_commercial`
cd $scriptdir
Firmware_Script=`cat Firmware_Script`


cat <<EOF > manifest.new 
<?xml version="1.0" encoding="utf-8"?> 
<package> 
  <metadata> 
    <dc-metadata> 
      <Title>Restore the iRex offical iPDF's poppler</Title> 
      <Description>Restored the original poppler on $(date +"%Y-%m-%d at %H:%M:%S")</Description> 
      <Date>2009-03-01T10:54:28</Date> 
    </dc-metadata> 
    <y-metadata> 
      <startpage>restore_poppler.sh</startpage> 
      <image>pdf.png</image> 
      <version>001</version>
    <ItemSize>1530478</ItemSize></y-metadata> 
  </metadata> 
</package> 
EOF


if echo $Firmware_iLiad | grep $Firmware_Script - ; then
	cp -f ${scriptdir}/libpoppler.so.1.0.0.backup /usr/lib/libpoppler.so.1.0.0
	mv manifest.new manifest.xml
else
	# wrong firmware version
	# script is deactivated, error message
	cat wrong_fw.xml | sed -e "s/Firmware_Script_xml/$Firmware_Script/" > manifest.xml
	cat manifest.xml | sed -e "s/Firmware_iLiad_xml/$Firmware_iLiad/" > manifest.xml
fi
