#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
www.lenta.ru
'''

import re
from calibre.web.feeds.news import BasicNewsRecipe

class Lenta(BasicNewsRecipe):
    title                 = 'Lenta.ru'
    __author__            = 'Darko Miletic'
    description           = u'Ежедневная интернет-газета. Новости со всего мира на русском языке'
    publisher             = u'Rambler Media Group'
    category              = u'news, Russia, politics'    
    language              = _('Russian')
    oldest_article        = 1
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'cp1251'
    remove_javascript     = True
    use_embedded_content  = False
    extra_css = '@font-face {font-family: "serif0";src:url(res:///Data/FONT/serif0.ttf)} @font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif0, serif1, serif} .article_description{font-family: serif0, serif1, serif} a.article{font-family: serif0, serif1, serif}'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 

    preprocess_regexps = [(re.compile('</title>'), lambda match: '</title></head><body>')]    

    remove_tags = [dict(name=['link','base'])]

    feeds = [(u'НОВОСТИ', u'http://img.lenta.ru/r/EX/import.rss')]

    def preprocess_html(self, soup):
        mtag = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>'
        soup.head.insert(0,mtag)
        return soup

    def print_version(self, url):
        return url + '_Printed.htm'
        