#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
www.izvestia.ru
'''

from calibre.web.feeds.news import BasicNewsRecipe

class Izvestia(BasicNewsRecipe):
    title                 = 'Izvestia'
    __author__            = 'Darko Miletic'
    description           = u'Общенациональная ежедневная газета ИЗВЕСТИЯ'
    publisher             = u'ИЗВЕСТИЯ'
    category              = u'Газета Известия,  Известия,  российская газета,  общенациональная,  москва,  регионы,  рефераты, материалы для рефератов,  экзамены,  новости,  аналитика,  финансы,  последние события, Израиль,  США,  Путин, Буш,  Светская жизнь,  Теракты,  11 сентября,  Акунин,  Литература,  Бизнес,  Жизнь,  Шоу-бизнес,  Звезды,  Политика ,  Экономика,  Культура,  Чечня,  Архив,  Олимпиада,  Спорт,  Чемпионат мира,  Лечение,  Лекарства,  Премии,  Церемонии,  Сенсация,  Репортаж,  Фото,  Наука,  Телевидение,  Реклама,  Лучший,  Пресса,  Терроризм,  Касьянов,  Селезнгев,  Жириновский,  Футбол,  Курникова,  Пугачева,  Киркоров,  Галкин,  Басков,  Земфира,  Баскетбол,  Автоновости,  Автомобили,  Музыка'    
    language              = _('Russian')
    oldest_article        = 1
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'cp1251'
    remove_javascript     = True
    use_embedded_content  = False
    extra_css = '@font-face {font-family: "serif0";src:url(res:///Data/FONT/serif0.ttf)} @font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif0, serif1, serif} .article_description{font-family: serif0, serif1, serif} a.article{font-family: serif0, serif1, serif}'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 

    keep_only_tags = [
                        dict(name=['h1','h2'], attrs={'class':'statya'})
                       ,dict(name='div', attrs={'class':'rubrAuthor'})
                       ,dict(name='span', attrs={'class':'text'})
                     ]
    
    remove_tags = [
                     dict(name=['object','link','iframe','base'])
                  ]

    feeds = [(u'ИЗВЕСТИЯ', u'http://rss.feedsportal.com/c/32171/f/424076/index.rss')]

    def preprocess_html(self, soup):
        mtag = '<meta http-equiv="Content-Language" content="ru-RU"/>'
        soup.head.insert(0,mtag)
        for item in soup.findAll(style=True):
            del item['style']
        for item in soup.findAll(font=True):
            del item['font']
        return soup
   