import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import com.sun.org.apache.bcel.internal.verifier.structurals.Frame;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.FormatDetector;

public class RSS2Book {
	public Vector<String> Feeds = new Vector<String>();

	public Vector<String> URLs = new Vector<String>();

	public Vector<Vector> Customizations = new Vector<Vector>();
	
	public Vector<String> PDFgroups = new Vector<String>();

	public JList list;

	public JTextField url;
	
	public JTextField urlQuick;
	
	public JTextField nameQuick;

	public Date date;

	public JTextField days = new JTextField(2);

	public ChannelIF channel;

	public URL imageLoc;

	public String copyright;

	public JTextField outField;

	public Dimension maxSize = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

	public ImageIcon throbber = new ImageIcon("Spinning_wheel_throbber.gif");
	
	public JFrame websites;
	
	public JFrame quickFrame;
	
	public JLabel throbberLabel;
	
	public JFrame prefs;
	
	public boolean notChanging=true;

	public JTextField HTMLField;
	
	public JCheckBox htmlEnabled;
	
	public JCheckBox addHTMLenabled;
	
	public JCheckBox filteringEnabled;

	public JTextField HTMLOptionsField;
	
	public String tempURL="";
	
	public JTable PDFtable;
	
	public JComboBox GroupList;

	public JTextField LinkExtractorPattern;
	
	public JTextField ContentReformatter;
	
	public JTextField URLField;
	
	public JTextField NameField;

	public JTextField LinkReformatter;

	public JTextField ContentExtractionPattern;

	public String osName = System.getProperty("os.name");

	public JCheckBox ejectBox = new JCheckBox(
			"eject media card after generating news?");

	public int selectedWhenCustomized;

	//preference variables
	public String htmlLocString = "";

	public String outputString = "";

	public String htmlOptions = "";

	public boolean eject = false;

	/**
	 * @param args
	 * @throws ParseException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException, ParseException {
		RSS2Book rss = new RSS2Book();
		rss.go();
	}

	public void go() throws IOException, ParseException {
		read();
		gui();
		Thread run = new Thread(new LastRun());
		Runtime.getRuntime().addShutdownHook(run);
	}

	private void gui() {
		// TODO Auto-generated method stub
		JFrame theFrame = new JFrame("RSS2Book");
		theFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		list = new JList();
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane scroller = new JScrollPane(list);
		list.setListData(Feeds); // no data to start with
		list.setMaximumSize(maxSize);
		//list.setSize(maxSize);
		theFrame.getContentPane().add(BorderLayout.NORTH, scroller);

		JPanel buttons = new JPanel();
		JButton add = new JButton("Add Feed");
		add.addActionListener(new AddListenerFirst());
		buttons.add(add);
		JButton remove = new JButton("Remove Feed");
		remove.addActionListener(new RemoveListener());
		buttons.add(remove);
		JButton customize = new JButton("Customize Feed");
		customize.addActionListener(new CustomizeListener());
		buttons.add(customize);
		//put buttons on frame (center)
		theFrame.getContentPane().add(BorderLayout.CENTER, buttons);
		//working on the bottom section of the frame
		JPanel southPanel = new JPanel();
		JButton generate = new JButton("Generate New RSS2Book");
		southPanel.add(generate);
		generate.addActionListener(new Generate());
		JLabel note = new JLabel("...for the last");
		southPanel.add(note);
		southPanel.add(days);
		JLabel note1 = new JLabel("days.");
		southPanel.add(note1);
		JButton quickButton = new JButton("Quick Convert");
		quickButton.addActionListener(new QuickConvertFirst());
		southPanel.add(quickButton);
		JButton prefsButton = new JButton("Preferences");
		prefsButton.addActionListener(new PrefsWindow());
		southPanel.add(prefsButton);
		throbberLabel = new JLabel(new ImageIcon("blank.gif"));
		southPanel.add(throbberLabel);
		theFrame.getContentPane().add(BorderLayout.SOUTH, southPanel);
		//getting the window ready
		theFrame.setResizable(true);
		theFrame.pack();
		int width = theFrame.getWidth();
		int height = theFrame.getHeight();
		//do this so the window is the right size, but not to big if the screen itself is to small
		if (height > 709) {
			height = 500;
		}
		//calculate center of screen
//		 Get the default toolkit
		Toolkit toolkit = Toolkit.getDefaultToolkit();

		// Get the current screen size
		Dimension scrnsize = toolkit.getScreenSize();
		//center our Jframe
		theFrame.setBounds(scrnsize.width/2 - (width/2),
				scrnsize.height/2 - (height/2), width, height);
//		make it invisible because we don't want it running from the start
		theFrame.setVisible(true);

	}

	private void read() {
		// TODO Auto-generated method stub
		String daysString = "";
		try {
			File prefs = new File("prefs.conf");
			if (prefs.exists()) {
				FileInputStream fileIn = new FileInputStream(prefs);
				ObjectInputStream is = new ObjectInputStream(fileIn);
				Feeds = (Vector<String>) is.readObject();
				URLs = (Vector<String>) is.readObject();
				daysString = (String) is.readObject();
				htmlLocString = (String) is.readObject();
				outputString = (String) is.readObject();
				htmlOptions = (String) is.readObject();
				eject = (Boolean) is.readObject();
				PDFgroups= (Vector<String>) is.readObject();
				Customizations = (Vector<Vector>) is.readObject();
				days.setText(daysString);
			}//end if
			else { //code to setup HTMLDoc locations
				days.setText("0");
				PDFgroups.add("Default");
				if (osName.startsWith("Mac OS X")) {
					htmlLocString = "htmldoc";
					htmlOptions = "--book --links --textfont Helvetica --fontsize 14 --left 1mm --right 1mm --top 1mm --bottom 1mm --toclevels 2 --gray --size 5.24x6.69in --header ... --footer ... --textcolor black -f";
				}//if ends here
				if (osName.startsWith("Windows")) {
					htmlLocString = "C:\\Program Files\\Easy Software Products\\HTMLDOC\\htmldoc";
					htmlOptions = "--book --links --textfont Helvetica --fontsize 14 --left 1mm --right 1mm --top 1mm --bottom 1mm --toclevels 2 --gray --size 5.24x6.69in --header ... --footer ... --textcolor black -f";
				}//if ends here
				//write out new prefs
				try {
					FileOutputStream fileStream = new FileOutputStream(
							new File("prefs.conf"));
					ObjectOutputStream os = new ObjectOutputStream(fileStream);
					os.writeObject(Feeds);
					os.writeObject(URLs);
					os.writeObject(daysString);
					os.writeObject(htmlLocString);
					os.writeObject(outputString);
					os.writeObject(htmlOptions);
					os.writeObject(eject);
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}//close else if there is no pre-existing prefs
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public String create(String[] feeds, Vector<Vector> CustomizationsTemp, Date latestDate) throws IOException,
			ParseException {
		// TODO Auto-generated method stub
		Vector<String> temp;
		ChannelBuilderIF builder;
		URL feed;//feed we are using
		ImageIF image; // image used for title!
		String pub;
		Date dateOFPub;
		String description;
		builder = new de.nava.informa.impl.basic.ChannelBuilder();
		FeedParser parser = new FeedParser();
		String document = "<html>";
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(
				"EEEE, MMMM dd, yyyy hh:mm aaa");
		document = document + df.format(now) + "<body>\n<h1>The RSS Times for "
				+ df.format(now) + "</h1>";

		//ChannelIF channel = parser.parse(builder,feed);//use this to create a channel that is needed for a whole bunch of things
		int length = Array.getLength(feeds);
		for (int i = 0; i < length; i++) {
			URL imageLoc = null;
			feed = new URL(feeds[i]);
			ChannelIF channel = parser.parse(builder, feed);
			image = channel.getImage();
			if (!(image == null)) {
				imageLoc = image.getLocation();
			}
			pub = channel.getTitle();
			description = channel.getDescription();
			copyright = channel.getCopyright();
			dateOFPub = channel.getPubDate();
			document = document + "<h1>" + pub + "</h1>";
			if (!(imageLoc == null)) {
				if (((int) imageLoc.toString().length()) > 2) {
					document = document + "<p><img src=\"" + imageLoc
							+ "\"></p>";
				}
			}//close  big if

			if (((int) description.length()) > 2) {
				document = document + "<p>" + description + "</p>";

			}
			if (!(dateOFPub == null)) {
				String PubStringDate = df.format(dateOFPub);
				document = document + "<p>" + PubStringDate + "</p>";
			}
			temp = CustomizationsTemp.get(i);
			String tempString = temp.get(1);
			if (tempString.equals("")) {
				for (Iterator iter = channel.getItems().iterator(); iter
						.hasNext();) {//dump items for feed itself
					ItemIF item = (ItemIF) iter.next();
					Date postDate = item.getDate();
					if (latestDate.compareTo(postDate) >= 0) {//add if for date here
						document = document + "<h2>" + item.getTitle()
								+ "</h2>"; //add title
						document = document + "<p>" + df.format(postDate)
								+ "</p>";
						document = document + item.getDescription();
					}
				}//close for for printing out feeds into string
			} else {
				//else code to do if feed DOES use special extracting code
				Pattern LinkPattern = Pattern.compile(temp.get(0));
				System.out.println("pattern: " + temp.get(1));
				for (Iterator iter = channel.getItems().iterator(); iter
						.hasNext();) {//dump items for feed itself
					ItemIF item = (ItemIF) iter.next();
					Date postDate = item.getDate();
					if (latestDate.compareTo(postDate) >= 0) {//add if for date here
						document = document + "<h2>" + item.getTitle()
								+ "</h2>"; //add title
						document = document + "<p>" + df.format(postDate)
								+ "</p>";
						String link = item.getLink().toString();
						System.out.println("link: " + link);
						Matcher LinkMatcher = LinkPattern.matcher(link);
						LinkMatcher.find();
						//	String linkSubstring = link.substring(LinkMatcher.start(), LinkMatcher.end());
						//	System.out.println("linksub: "+linkSubstring);
						String reformattedLink = temp.get(1);
						String search;
						int groupCount = LinkMatcher.groupCount() + 1;//add one so that the for loop below can reach a number hight enough
						System.out.println("groupCount: " + groupCount);
						for (int k = 0; k < groupCount; k++) {
							search = "\\{" + k + "\\}";
							reformattedLink = reformattedLink.replaceAll(
									search, LinkMatcher.group(k));
							System.out.println(k + " this link "
									+ reformattedLink);
						}
						System.out.println("Reformatted link: "
								+ reformattedLink);
						System.out.println();
						//download reformattedLink
						//        				code to put website into a string
						String INPUT = "";
						try {
							int len = 0;
							char[] buf = new char[4000];
							URL url = new URL(reformattedLink);
							InputStream in = url.openStream();
							InputStreamReader reader = new InputStreamReader(in);
							while ((len = reader.read(buf)) > 0) {
								String tempInput = new String(buf);
								INPUT = INPUT + tempInput;
								buf = new char[4000];
							}
							//close the stream 
							reader.close();
						} catch (Exception e) {
							e.printStackTrace();
						}
						//end website-dumping while
						//   System.out.println("input \n "+INPUT);
						
						Pattern contentPattern = Pattern.compile(temp.get(2),
								Pattern.DOTALL);
						System.out.println("get 2: " + temp.get(2));
						Matcher contentMatcher = contentPattern.matcher(INPUT);
						while (contentMatcher.find()) {
							System.out.println("start: "
									+ contentMatcher.start() + " end: "
									+ contentMatcher.end());
							String TempINPUT = (String) INPUT.subSequence(
									contentMatcher.start(), contentMatcher
											.end());
							System.out.println("TempINPUT:\n" + TempINPUT);
							document = document + TempINPUT;
						}
						//	System.out.println("added to doc: "+TempINPUT);
					}
				}//close for for printing out feeds into string
			}
			if (!(copyright == null)) {
				if (((int) copyright.length()) > 2) {
					document = document + "<p>" + copyright + "</p>";
				}
			}//close bigger if
		}//clsoe for for list of feeds
		//  System.out.println("document:\n"+document);
		return document;
	}

	//listeners
	public class RemoveListener implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			int selected = list.getSelectedIndex();
			Feeds.remove(selected);
			URLs.remove(selected);
			list.setListData(Feeds);
		}
	}

	public class CustomizeListener implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			int selected = list.getSelectedIndex();
			selectedWhenCustomized = selected;
			Vector<String> temp = Customizations.get(selected);
			JFrame customizationsWindow = new JFrame("RSS2Book Preferences");
			customizationsWindow.addWindowListener(new SaveCustomizations());
			JPanel panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
			//add panel to frame
			customizationsWindow.getContentPane().add(BorderLayout.CENTER,
					panel);
			//now output location stuff
			JPanel OutLoc = new JPanel();
			panel.add(OutLoc);
			OutLoc.add(new JLabel("URL:"));
			URLField = new JTextField(URLs.get(selected));
			URLField.setColumns(23);
			OutLoc.add(URLField);
			OutLoc.add(new JLabel("Name:"));
			NameField = new JTextField(Feeds.get(selected));
			NameField.setColumns(23);
			OutLoc.add(NameField);
			htmlEnabled = new JCheckBox("HTML Page",Boolean.parseBoolean(temp.get(3)));
			OutLoc.add(htmlEnabled);
			filteringEnabled = new JCheckBox("Enable Filtering",Boolean.parseBoolean(temp.get(4)));
			OutLoc.add(filteringEnabled);
			//we need to do this regardless of whether it is used
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(new JLabel("PDF File Group:"));
			}
			GroupList = new JComboBox(PDFgroups);
			int selectedInGroupList=Integer.parseInt(temp.get(5));
			if(selectedInGroupList<=(PDFgroups.size()-1)){
			GroupList.setSelectedIndex(selectedInGroupList);
				}//close pdf group test
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(GroupList);
				}//end PDF File Group if
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(new JLabel("Link Extractor Pattern:"));
			}
			LinkExtractorPattern = new JTextField(temp.get(0));
			LinkExtractorPattern.setColumns(23);
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(LinkExtractorPattern);
			}
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(new JLabel("Link Reformatter:"));
			}
			LinkReformatter = new JTextField(temp.get(1));
			LinkReformatter.setColumns(23);
			if(!Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(LinkReformatter);
			}
			OutLoc.add(new JLabel("Content Extraction Pattern:"));
			ContentExtractionPattern = new JTextField(temp.get(2));
			ContentExtractionPattern.setColumns(23);
			OutLoc.add(ContentExtractionPattern);
			if(Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(new JLabel("Content Reformatter:"));
			}
			ContentReformatter = new JTextField(temp.get(6));
			ContentReformatter.setColumns(23);
			if(Boolean.parseBoolean(temp.get(3))){
			OutLoc.add(ContentReformatter);
			}
			customizationsWindow.setBounds(120, 120, 300, 380);
			customizationsWindow.setVisible(true);

		}
	}

	public class SaveCustomizations implements WindowListener {
		public void windowClosing(WindowEvent e)  {
			URLs.set(selectedWhenCustomized, URLField.getText());
			Feeds.set(selectedWhenCustomized, NameField.getText());
			list.setListData(Feeds);//so the list of feeds reflects updates
			//code for putting everything that needs to be put into a vector into a vector
			Vector<String> temp = new Vector<String>();
			temp.add(LinkExtractorPattern.getText());
			temp.add(LinkReformatter.getText());
			temp.add(ContentExtractionPattern.getText());
			temp.add(Boolean.toString(htmlEnabled.isSelected()));
			temp.add(Boolean.toString(filteringEnabled.isSelected()));
			temp.add(Integer.valueOf(GroupList.getSelectedIndex()).toString());
			temp.add(ContentReformatter.getText());
			Customizations.add(selectedWhenCustomized, temp);
		}

		public void windowActivated(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

		public void windowClosed(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

		public void windowDeactivated(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

		public void windowDeiconified(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

		public void windowIconified(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

		public void windowOpened(WindowEvent e) {
			// TODO Auto-generated method stub
			
		}

	}

	public class AddListener implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			if(!addHTMLenabled.isSelected()){
			ChannelBuilderIF builder;
			URL feed;
			try {
				feed = new URL(url.getText());

				builder = new de.nava.informa.impl.basic.ChannelBuilder();
				FeedParser parser = new FeedParser();

				channel = parser.parse(builder, feed);

			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (!channel.getTitle().equals("")) {
				Feeds.add(channel.getTitle());
				URLs.add(url.getText());
				list.setListData(Feeds);
			}//close checking if
			//enter blank vector for this newly-added feed
			}else{ //close RSS feed if
//				a little url manipulation
				String url1 = url.getText();
				Calendar cal = Calendar.getInstance();
				String year4 = Integer.toString(cal.get(Calendar.YEAR));
				String year2 = year4.substring(2,4);
				String month = Integer.toString(cal.get(Calendar.MONTH));
				String day = Integer.toString(cal.get(Calendar.DAY_OF_MONTH)+1);
				Pattern pattern1 = Pattern.compile("@yyyy",Pattern.DOTALL);
				Matcher matcher1 = pattern1.matcher(url1);
				url1=matcher1.replaceAll(year4);
				pattern1 = Pattern.compile("@yy",Pattern.DOTALL);
				matcher1 = pattern1.matcher(url1);
				url1=matcher1.replaceAll(year2);
				pattern1 = Pattern.compile("@mm",Pattern.DOTALL);
				matcher1 = pattern1.matcher(url1);
				url1=matcher1.replaceAll(month);
				pattern1 = Pattern.compile("@dd",Pattern.DOTALL);
				matcher1 = pattern1.matcher(url1);
				url1=matcher1.replaceAll(day);
				System.out.println("url:"+url1);
				//download site so we can get a name out of it
				String INPUT = "";
				try {
					int len = 0;
					char[] buf = new char[4000];
					URL url = new URL(url1);
					InputStream in = url.openStream();
					InputStreamReader reader = new InputStreamReader(in);
					while ((len = reader.read(buf)) > 0) {
						String tempInput = new String(buf);
						INPUT = INPUT + tempInput;
						buf = new char[4000];
					}
					//close the stream 
					reader.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
				//find name
				Pattern pattern = Pattern.compile("<title>(.*)</title>",Pattern.CASE_INSENSITIVE);
				Matcher matcher = pattern.matcher(INPUT);
				String name="";
				if(matcher.find()){
				name = matcher.group(1);
				}else{
					//make name untitled
					name="Untitled";
				}
				Feeds.add(name);
				URLs.add(url.getText());
				list.setListData(Feeds);
			}//close else
			Vector<String> temp = new Vector<String>();
			temp.add("");
			temp.add("");
			temp.add("");
			temp.add(Boolean.toString(addHTMLenabled.isSelected()));
			temp.add("false");
			temp.add("0");
			temp.add("");
			Customizations.add(Feeds.size() - 1, temp);
			//close add window
			websites.dispose();
		}
	}

	public class AddListenerFirst implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			websites = new JFrame("Add Website/RSS Feed");
			url = new JTextField("http://", 20);
			JButton add = new JButton("Add");
			add.addActionListener(new AddListener());
			addHTMLenabled = new JCheckBox("HTML Page");
			JPanel webPanel = new JPanel();
			websites.getContentPane().add(BorderLayout.CENTER, webPanel);
			webPanel.add(url);
			webPanel.add(addHTMLenabled);
			webPanel.add(add);
			websites.setBounds(120, 120, 300, 150);
			websites.pack();
			websites.setVisible(true);

		}
	}
	public class QuickListener implements ActionListener {
		public void actionPerformed(ActionEvent a){
			try {
				String url = urlQuick.getText();
				String name = nameQuick.getText();
				Runtime htmldocRunner = Runtime.getRuntime();
				Process htmldoc = htmldocRunner.exec(htmlLocString + " "
						+ htmlOptions.replaceAll("--book", "--webpage") + " " + outputString+File.separator+name+ " "+url);

				//some code to keep everything running smoothly
				InputStream in = htmldoc.getInputStream();
				InputStreamReader reader = new InputStreamReader(in);
				int len;
				char[] buf = new char[4000];
				while ((len = reader.read(buf)) > 0) {
					//System.out.println(buf);
				}

				//close the stream 
				reader.close();
				quickFrame.dispose();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	public class QuickConvertFirst implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			quickFrame = new JFrame("Quick Convert");
			urlQuick = new JTextField("http://", 20);
			nameQuick = new JTextField("Untitled", 20);
			JButton add = new JButton("Quick Convert");
			add.addActionListener(new QuickListener());
			JPanel webPanel = new JPanel();
			quickFrame.getContentPane().add(BorderLayout.CENTER, webPanel);
			webPanel.add(urlQuick);
			webPanel.add(nameQuick);
			webPanel.add(add);
			quickFrame.setBounds(120, 120, 300, 150);
			//quickFrame.pack();
			quickFrame.setVisible(true);

		}
	}

	public class Generate implements ActionListener {
		public void actionPerformed(ActionEvent a){
			throbberLabel.setIcon(new ImageIcon("Spinning_wheel_throbber.gif"));
			Thread generateThread = new Thread(new GeneratingThread());
			generateThread.start();
		}
	}

	public class GeneratingThread implements Runnable {

		public void run() {
			try {
	//			make it our status throbber visible
				//throbberLabel.setVisible(true);
				Vector<Integer> htmlPages = new Vector<Integer>();
				for(int i =0;i<PDFgroups.size();i++){
				//add this one
				//get name of group
				String name = PDFgroups.get(i);
				Vector<Integer> pagesInThisGroup = new Vector<Integer>();
				for(int ii=0;ii<Feeds.size();ii++){
					//add this one
					Vector<String> temp5 = Customizations.get(ii);
				if(Integer.parseInt(temp5.get(5))==i){
					Vector<String> tempVector = Customizations.get(ii);
					if(!Boolean.parseBoolean(tempVector.get(3))){
					pagesInThisGroup.add(ii);
					}
				}
				//make a string array with feeds (using vector)
				//first we have to make new vectors for this group of feeds
				if(pagesInThisGroup.size()>0){
				Vector<String> URLsTemp = new Vector<String>();
				Vector<Vector> CustomizationsTemp = new Vector<Vector>();
				for(int iii=0;iii<pagesInThisGroup.size();iii++){
					int tempInt = pagesInThisGroup.get(iii);
					URLsTemp.add(URLs.get(tempInt));
					CustomizationsTemp.add(Customizations.get(tempInt));
				}
				Object[] temp = URLsTemp.toArray();
				String[] StringFeeds = new String[temp.length];
	
				System.arraycopy(temp, 0, StringFeeds, 0, StringFeeds.length);
	
				date = new Date();
				Calendar cal = Calendar.getInstance();
				cal.setTime(date);
				long dateInMillies = cal.getTimeInMillis();
				int daysSubtracted = Integer.parseInt(days.getText());
				dateInMillies = dateInMillies - (daysSubtracted * 86400000);
				cal.setTimeInMillis(dateInMillies);
				date = cal.getTime();
	
				try {
					//create temp html
					System.out.println("StringFeeds length: "+StringFeeds.length);
					String output = create(StringFeeds, CustomizationsTemp, date);
					File outputHtml = new File("temp.html");
					BufferedWriter writer = new BufferedWriter(new FileWriter(
							outputHtml));
					writer.write(output);
					writer.close();
					//convert temp html to pdf output
					Runtime htmldocRunner = Runtime.getRuntime();
					Process htmldoc = htmldocRunner.exec(htmlLocString + " "
							+ htmlOptions + " " + "temp.pdf" + " temp.html");
	
					//some code to keep everything running smoothly
					InputStream in = htmldoc.getInputStream();
					InputStreamReader reader = new InputStreamReader(in);
					int len;
					char[] buf = new char[4000];
					while ((len = reader.read(buf)) > 0) {
						//System.out.println(buf);
					}
	
					//close the stream 
					reader.close();
					//	          copy temp.pdf to final location, then delete temp.pdf
					File tempPDF = new File("temp.pdf");
					copyDirectory(tempPDF, new File(outputString + name +".pdf"));
					tempPDF.delete();
					File temp1 = new File("temp.html");
					//temp1.delete();
					//end smoothing code
					
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				}//close feeds for
				}//close if (the if to test whether a group has more than 0 items)
				}//close groups for
				//do html page conversion
				for(int ii=0;ii<Feeds.size();ii++){
					Vector<String> temp5 = Customizations.get(ii);
					if(Boolean.parseBoolean(temp5.get(3))){
					String url = URLs.get(ii);
					//a little url manipulation
					Calendar cal = Calendar.getInstance();
					String year4 = Integer.toString(cal.get(Calendar.YEAR));
					String year2 = year4.substring(2,4);
					String month = Integer.toString(cal.get(Calendar.MONTH)+1);
					String day = Integer.toString(cal.get(Calendar.DAY_OF_MONTH));
					Pattern pattern1 = Pattern.compile("@yyyy",Pattern.DOTALL);
					Matcher matcher1 = pattern1.matcher(url);
					url=matcher1.replaceAll(year4);
					pattern1 = Pattern.compile("@yy",Pattern.DOTALL);
					matcher1 = pattern1.matcher(url);
					url=matcher1.replaceAll(year2);
					pattern1 = Pattern.compile("@mm",Pattern.DOTALL);
					matcher1 = pattern1.matcher(url);
					url=matcher1.replaceAll(month);
					pattern1 = Pattern.compile("@dd",Pattern.DOTALL);
					matcher1 = pattern1.matcher(url);
					url=matcher1.replaceAll(day);
					System.out.println("url:"+url);
					//download site
					String INPUT = "";
					try {
						int len = 0;
						char[] buf = new char[4000];
						URL url1 = new URL(url);
						InputStream in = url1.openStream();
						InputStreamReader reader = new InputStreamReader(in);
						while ((len = reader.read(buf)) > 0) {
							String tempInput = new String(buf);
							INPUT = INPUT + tempInput;
							buf = new char[4000];
						}
						//close the stream 
						reader.close();
					} catch (Exception e) {
						e.printStackTrace();
					}
					//end downloading site
					String contentReformatterString = temp5.get(6);
					if(!Boolean.parseBoolean(temp5.get(4))){
						contentReformatterString="{0}";
					}
					//reformat content
					//get pattern
					String contentPattern="";
					if(Boolean.parseBoolean(temp5.get(4))){
					contentPattern = temp5.get(2);
					}else{
					contentPattern="(.*)";	
					}
					Pattern pattern = Pattern.compile(contentPattern,Pattern.DOTALL);
					Matcher matcher = pattern.matcher(INPUT);
					matcher.find();
					String[] parts = contentReformatterString.split("{0}");
					contentReformatterString=parts[0]+matcher.group(0)+parts[1];
					//make links absolute
					Pattern contentPatternSrc = Pattern.compile("(?i)src=\"(.*?)\"",Pattern.DOTALL);
					Matcher contentMatcher = contentPatternSrc.matcher(contentReformatterString);
					while(contentMatcher.find()){
					String group1=contentMatcher.group(1);
					System.out.println("group1: "+group1);
					String tempGroup1="";	
					if(!group1.startsWith("http")){
							URL url1 = new URL(url);
							if(group1.startsWith("/")){
								tempGroup1="http://"+url1.getHost()+group1;
							}else{
								String[] URLparts=url.split("/");
								int len = Array.getLength(URLparts);
								String lastPart = URLparts[len-1];
								//do this because we dont want to use a URL that is actually a pointer to a direct file
								if(lastPart.contains(".")){
									int cutOff = url.length()-lastPart.length();
									 tempURL = url.substring(0, cutOff);
									 System.out.println("without dot:"+tempURL);
								}else{
									tempURL=url;
								}
								tempGroup1=tempURL+group1;
							}
							
						}else{
							tempGroup1=group1;
						}
						//update our little string
						contentReformatterString=contentReformatterString.replaceAll(group1, tempGroup1);
					}//end src finding while
					//create pdf
					File outputHtml = new File("temp.html");
					BufferedWriter writer = new BufferedWriter(new FileWriter(
							outputHtml));
					writer.write(contentReformatterString);
					writer.close();
					//convert temp html to pdf output
					Runtime htmldocRunner = Runtime.getRuntime();
					Process htmldoc = htmldocRunner.exec(htmlLocString + " "
							+ htmlOptions.replaceAll("--book", "--webpage") + " " + "temp.pdf" + " temp.html");
	
					//some code to keep everything running smoothly
					InputStream in = htmldoc.getInputStream();
					InputStreamReader reader = new InputStreamReader(in);
					int len;
					char[] buf = new char[4000];
					while ((len = reader.read(buf)) > 0) {
						//System.out.println(buf);
					}
	
					//close the stream 
					reader.close();
					//	          copy temp.pdf to final location, then delete temp.pdf
					File tempPDF = new File("temp.pdf");
					copyDirectory(tempPDF, new File(Feeds.get(ii)+".pdf"));
					tempPDF.delete();
					File temp1 = new File("temp.html");
					//temp1.delete();
					//end create pdf
					}
				}
				try {
					//code (mac only currently....) to eject the media card be used
					if (eject) {
						if (osName.startsWith("Mac OS X")) {
							Runtime ejecter = Runtime.getRuntime();
							File temp2 = new File(outputString);
							String stringParent = temp2.toString();
							temp2 = null;
							Process ejecterProc = ejecter.exec("diskutil unmount "
									+ stringParent);
							//		        	some code to keep everything running smoothly
							InputStream in1 = ejecterProc.getInputStream();
							InputStreamReader reader1 = new InputStreamReader(in1);
							int len1;
							char[] buf1 = new char[4000];
							while ((len1 = reader1.read(buf1)) > 0) {
							}
	
							//close the stream 
							reader1.close();
							//end smoothing code
						}//if ends here
					}//if from eject ends here
					//end code for ejecting
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
} catch (NumberFormatException e) {
	// TODO Auto-generated catch block
	e.printStackTrace();
} catch (IOException e) {
	// TODO Auto-generated catch block
	e.printStackTrace();
}
throbberLabel.setIcon(new ImageIcon("mark.gif"));
		}
	}

	public class LastRun implements Runnable {

		public void run() {
			//    		code to write prefs
			String daysString = days.getText();
			try {
				FileOutputStream fileStream = new FileOutputStream(new File(
						"prefs.conf"));
				ObjectOutputStream os = new ObjectOutputStream(fileStream);
				os.writeObject(Feeds);
				os.writeObject(URLs);
				os.writeObject(daysString);
				os.writeObject(htmlLocString);
				os.writeObject(outputString);
				os.writeObject(htmlOptions);
				os.writeObject(eject);
				os.writeObject(PDFgroups);
				os.writeObject(Customizations);
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			//exit
		}
	}

	public class PrefsWindow implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			prefs = new JFrame("RSS2Book Preferences");
			prefs.addWindowListener(new SavePreferences());
			JPanel panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
			//add panel to frame
			prefs.getContentPane().add(BorderLayout.CENTER, panel);
			//now output location stuff
			JPanel HTMLPanel = new JPanel();
			panel.add(HTMLPanel);
			HTMLPanel.add(new JLabel("Output location:"));
			outField = new JTextField(outputString);
			outField.setColumns(23);
			HTMLPanel.add(outField);
			JButton chooseOut = new JButton("Choose...");
			chooseOut.setAlignmentX(Component.CENTER_ALIGNMENT);
			chooseOut.addActionListener(new ChooseOut());
			HTMLPanel.add(chooseOut);
			HTMLPanel.add(Box.createRigidArea(new Dimension(108,0)));
			//now HTMLdoc stuff
			HTMLPanel.add(new JLabel("HTMLDOC Location:"));
			HTMLField = new JTextField(htmlLocString);
			HTMLField.setColumns(23);
			HTMLPanel.add(HTMLField);
			HTMLPanel.add(new JLabel("HTMLDOC Options:"));
			HTMLOptionsField = new JTextField(htmlOptions);
			HTMLOptionsField.setColumns(23);
			HTMLPanel.add(HTMLOptionsField);
			//a little something i need to add to htmlpanel to make life easier
			if (osName.startsWith("Mac OS X")) {
				ejectBox.setSelected(eject);
				HTMLPanel.add(ejectBox);
			}//if ends here
			//pdf file groups
			Vector<String> columnNames = new Vector<String>();
			columnNames.add("PDF File Groups");
			//make our new shiny vector
			Vector<Vector> tempVector = new Vector<Vector>();
			//test
			System.out.println(PDFgroups.get(0));
			//end test
			int len = PDFgroups.size();
			for(int i=0;i<len;i++){
				Vector<String> cookieCutter = new Vector<String>();
				cookieCutter.add(PDFgroups.get(i));
				tempVector.add(cookieCutter);
			}
			PDFtable = new JTable(tempVector, columnNames);
			PDFtable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			PDFtable.getModel().addTableModelListener(new PDFgroupListener());
		    JScrollPane scrollPane = new JScrollPane(PDFtable);
		    PDFtable.setPreferredScrollableViewportSize(new Dimension(260, 100));
			HTMLPanel.add(scrollPane);
			//table buttons
			JButton addGroup = new JButton("Add Group");
			addGroup.addActionListener(new addGroup());
			HTMLPanel.add(addGroup);
			JButton removeGroup = new JButton("Remove Group");
			removeGroup.addActionListener(new removeGroup());
			HTMLPanel.add(removeGroup);
			//save button code follows

			prefs.setBounds(120, 120, 300, 390);
			prefs.setVisible(true);

		}
	}

	public class SavePreferences implements WindowListener {
		public void windowClosing(WindowEvent e)  {
			outputString = outField.getText();
			htmlLocString = HTMLField.getText();
			htmlOptions = HTMLOptionsField.getText();
			eject = ejectBox.isSelected();
			//write out new prefs
			try {
				FileOutputStream fileStream = new FileOutputStream(new File(
						"prefs.conf"));
				ObjectOutputStream os = new ObjectOutputStream(fileStream);
				os.writeObject(Feeds);
				os.writeObject(URLs);
				os.writeObject(days.getText());
				os.writeObject(htmlLocString);
				os.writeObject(outputString);
				os.writeObject(htmlOptions);
				os.writeObject(eject);
				os.writeObject(PDFgroups);
				os.writeObject(Customizations);
			} catch (Exception ex) {
				ex.printStackTrace();
			}

		}

		public void windowActivated(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		public void windowClosed(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		public void windowDeactivated(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		public void windowDeiconified(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		public void windowIconified(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		public void windowOpened(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}
	}
	public class addGroup implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			notChanging=false;
			PDFgroups.add("");
			DefaultTableModel model = (DefaultTableModel)PDFtable.getModel();
			int len = PDFtable.getRowCount();
			String temp[]={""};
			model.addRow(temp);
			PDFtable.setRowSelectionInterval(PDFtable.getRowCount()-1, PDFtable.getRowCount()-1);
			notChanging=true;
		}
	}

	public class removeGroup implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			notChanging=false;
			PDFgroups.remove(PDFtable.getSelectedRow());
			DefaultTableModel model = (DefaultTableModel)PDFtable.getModel();
			model.removeRow(PDFtable.getSelectedRow());
			notChanging=true;
		}
	}

	public class ChooseOut implements ActionListener {
		public void actionPerformed(ActionEvent a) {
			JFileChooser chooser = new JFileChooser();
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int status = chooser.showOpenDialog(prefs);
			if (status == JFileChooser.APPROVE_OPTION) {
				File temp = chooser.getSelectedFile();
				outField.setText(temp.toString());
			}

		}
	}
	public class PDFgroupListener implements TableModelListener {
		public void tableChanged(TableModelEvent e) {
	       if(notChanging){
	    	   int row = e.getFirstRow();
	    	   int column = e.getColumn();
	    	   TableModel model = (TableModel)e.getSource();
	    	   String name = (String) model.getValueAt(row, column);
	    	   PDFgroups.set(row, name);
	    	   // Do something with the data...
	       }
	    }
	}

	//  http://www.java-tips.org/java-se-tips/java.io/how-to-copy-a-directory-from-one-location-to-another-location.html
	//i learned the basics about this method and how to build it from http://www.java-tips.org/java-se-tips/java.io/how-to-copy-a-directory-from-one-location-to-another-location.html 
	//If targetLocation does not exist, it will be created.
	public void copyDirectory(File sourceLocation, File targetLocation)
			throws IOException {

		if (sourceLocation.isDirectory()) {
			if (!targetLocation.exists()) {
				targetLocation.mkdir();
			}

			String[] children = sourceLocation.list();
			for (int i = 0; i < children.length; i++) {
				copyDirectory(new File(sourceLocation, children[i]), new File(
						targetLocation, children[i]));
			}
		} else {

			InputStream in = new FileInputStream(sourceLocation);
			OutputStream out = new FileOutputStream(targetLocation);

			// Copy the bits from instream to outstream
			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}
			in.close();
			out.close();
		}
	}
}