#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
www.kp.ru
'''

from calibre.web.feeds.news import BasicNewsRecipe

class KomsomolskaiaPravda(BasicNewsRecipe):
    title                 = 'Komsomolskaia Pravda'
    __author__            = 'Darko Miletic'
    description           = u'КОМСОМОЛЬСКАЯ ПРАВДА. Наиболее популярная российская газета. Ежедневное обновление информации. Полностью бесплатный доступ. Самые интересные материалы, самые горячие новости.'
    publisher             = u'Комсомольская правда'
    category              = u'komsomolka, komsomolskaya pravda, newspaper, news, sport, комсомолка, газета, газеты, СМИ, комсомольская правда, статья, репортаж, обзор, новость, новости, интервью, пресса, периодика, периодические издания, периодическое издание, спорт, политика, экономика, культура, шоубизнес, гороскоп, реклама, интернет, война, корреспондент, автоликбез, издательство, прямая линия, клубный, пиджак, денежки, деньги, проекты, погода, подписка, кроссворд, консультации, консультация, жизнь, светская хроника, балабасня недели, дело бородина, дипкурьер, мода, секс клуб, сериалы, выборы'    
    language              = _('Russian')
    oldest_article        = 1
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'cp1251'
    remove_javascript     = True
    use_embedded_content  = False
    extra_css = '@font-face {font-family: "serif0";src:url(res:///Data/FONT/serif0.ttf)} @font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif0, serif1, serif} .article_description{font-family: serif0, serif1, serif} a.article{font-family: serif0, serif1, serif}'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 
     
    remove_tags = [
                     dict(name=['object','link','iframe','base'])
                    ,dict(name='div', attrs={'class':'footer-right'})
                    ,dict(name='div', attrs={'id':'logo'})
                  ]

    feeds = [(u'Комсомольская правда', u'http://kp.ru/rss.xml')]

    def preprocess_html(self, soup):
        mtag = '<meta http-equiv="Content-Language" content="ru-RU"/>'
        soup.head.insert(0,mtag)
        for item in soup.findAll(style=True):
            del item['style']
        for item in soup.findAll(font=True):
            del item['font']
        return soup

    def print_version(self, url):
        return url + 'print/'
   