#! /usr/bin/env lua

--[[
	"External" drag-n-drop example.
--]]

require("lgui")

-- Setup the GUI
local window = lgui.Window.new()
local scroll = lgui.ScrolledWindow.new()
local model = lgui.ListStore.new("gchararray")
local view = lgui.TreeView.newWithModel(model)
local selection = view:getSelection()
local col = lgui.TreeViewColumn.new("Text", lgui.CellRendererText.new(), "text", 0)
local iter = lgui.TreeIter.new()

view:appendColumn(col)

scroll:add(view)
window:add(scroll)
window:set("window-position", lgui.WIN_POS_CENTER, "title", "Hello Drag'n'Drop",
	"width-request", 300, "height-request", 200)
window:connect("delete-event", lgui.quit)

-- Setup the DnD
local entries  = lgui.TargetEntry.new(
	{"text/plain", 0, 1},
	{"text/uri-list", 0, 2}
)

lgui.DragSource.set(view, lgui.BUTTON1_MASK, entries, lgui.ACTION_COPY)
lgui.DragDest.set(view, lgui.DEST_DEFAULT_ALL, entries, lgui.ACTION_COPY)

-- When received a drop
function received(data, context, x, y, seldata, info, time)
	local txt = lgui.SelectionData.getText(seldata)
	
	if txt then
		model:append(iter)
		model:set(iter, 0, txt)
	end
end

-- When an application request the content from a droped data
function get(data, context, seldata, info, time)
	local res = selection:getSelected(iter)
	
	if res then
		lgui.SelectionData.setText(seldata, lgui.TreeModel.get(model, iter, 0))
	end
end

view:connect("drag-data-received", received)
view:connect("drag-data-get", get)

window:showAll()
lgui.main()
