#! /usr/bin/env lua

-- Sample application, in a OO way

require("lgui")

App = {}

---
-- Constructor
--
-- TODO: Accelerators
-- @return A new App instance
function App.new()
	local self = {}
	setmetatable(self, {__index = App})

	self.window = lgui.Window.new()
	self.vbox = lgui.VBox.new(false, 0)
	self.content = lgui.Label.new("Here goes the content")
	self.statusbar = lgui.Statusbar.new()
	self.context = self.statusbar:getContextId("default")
	self.statusbar:push(self.context, "Statusbar message")

	-- Actions
	self.aOpenFile = lgui.Action.new("Open File", nil, "Open a file", "gtk-open")
	self.aOpenFile:connect("activate", function() print("File opened!") end)
	self.aCopy = lgui.Action.new("Coapy", nil, "Copy selected text", "gtk-copy")
	self.aPaste = lgui.Action.new("Paste", nil, "Paste selected text", "gtk-paste")
	self.aQuit = lgui.Action.new("Quit", nil, "Quit from the application", "gtk-quit")
	self.aQuit:connect("activate", lgui.quit)
	self.aAbout = lgui.Action.new("About", nil, "About this application...", "gtk-about")
	self.aAbout:connect("activate", self.showAbout, self)

	-- AccelGroup
	self.accelGroup = lgui.AccelGroup.new()
	self.window:addAccelGroup(self.accelGroup)

	-- Action groups
	self.copyPasteGroup = lgui.ActionGroup.new("Copy paste")
	self.copyPasteGroup:addAction(self.aCopy, self.aPaste)
	self.copyPasteGroup:set("sensitive", false)

	self.fileGroup = lgui.ActionGroup.new("File")

	self.fileGroup:addActionWithAccel(self.aOpenFile)
	self.aOpenFile:setAccelGroup(self.accelGroup)

	self.fileGroup:addActionWithAccel(self.aQuit)
	self.aQuit:setAccelGroup(self.accelGroup)

	self.fileGroup:addActionWithAccel(self.aAbout, "F1")
	self.aAbout:setAccelGroup(self.accelGroup)

	-- Toolbar
	self.toolbar = lgui.Toolbar.new()
	self.toolbar:add(self.aOpenFile:createToolItem(), lgui.SeparatorToolItem.new(),
		self.aCopy:createToolItem(), self.aPaste:createToolItem(), lgui.SeparatorToolItem.new(),
		self.aAbout:createToolItem())

	-- Menu
	self.menubar = lgui.MenuBar.new()
	self.file = lgui.Menu.new()
	self.fileItem = lgui.MenuItem.newWithMnemonic("_File")
	self.openItem = self.aOpenFile:createMenuItem()
	self.quitItem = self.aQuit:createMenuItem()
	self.copyItem = self.aCopy:createMenuItem()
	self.pasteItem = self.aPaste:createMenuItem()
	lgui.MenuShell.append(self.file, self.openItem,  lgui.SeparatorMenuItem.new(),
		self.copyItem, self.pasteItem, lgui.SeparatorMenuItem.new(), self.quitItem)
	self.fileItem:setSubmenu(self.file)

	self.help = lgui.Menu.new()
	self.helpItem = lgui.MenuItem.newWithMnemonic("_Help")
	self.aboutItem = self.aAbout:createMenuItem()
	lgui.MenuShell.append(self.help, self.aboutItem)
	self.helpItem:setSubmenu(self.help)

	lgui.MenuShell.append(self.menubar, self.fileItem, self.helpItem)

	-- Packing it!
	self.vbox:packStart(false, false, 0, self.menubar)
	self.vbox:packStart(false, false, 0, self.toolbar)
	self.vbox:packStart(true, true, 0, self.content)
	self.vbox:packStart(false, false, 0, self.statusbar)
	self.window:add(self.vbox)

	-- About dialog
	self.about = lgui.AboutDialog.new()
	self.logo = lgui.Pixbuf.newFromFile("icon.png")
	self.about:set("program-name", "Sample Application", "authors", {"Lucas Hermann Negri <kkndrox@gmail.com>"},
	"comments", "No comments!", "license", "LGPL 3+", "logo", self.logo, "title", "About...")

	self.window:set("title", "Sample Application", "width-request", 300,
		"height-request", 300, "window-position", lgui.WIN_POS_CENTER,
		"icon-name", "gtk-about")

	self.window:connect("delete-event", lgui.quit)

	return self
end

---
-- Shows the about dialog
function App:showAbout()
	self.about:run()
	self.about:hide()
end

-- * Main *
local inst = App.new()
inst.window:showAll()

lgui.main()
