#! /usr/bin/env lua

-- About dialog

require("lgui")

-- Create the widgets
local window = lgui.Window.new()
local dialog = lgui.AboutDialog.new()
local button = lgui.Button.newFromStock("gtk-about")
local logo   = lgui.Pixbuf.newFromFile("icon.png")

function showAbout()
	dialog:run()
	dialog:hide()
end

function hook(data, uri)
	lgui.showUri((data or "") .. uri)
end

-- Set the hooks before the website
dialog.setEmailHook(hook, "mailto:")
dialog.setUrlHook(hook)

dialog:set("program-name", "AboutDialog demo", "authors", {"Lucas Hermann Negri <kkndrox@gmail.com>"},
"comments", "No comments!", "license", "LGPL 3+", "logo", logo, "title", "About...",
"website", "http://oproj.tuxfamily.org")

window:add(button)
window:set("title", "About Dialog", "window-position", lgui.WIN_POS_CENTER)

window:connect("delete-event", lgui.quit)
button:connect("clicked", showAbout)

window:showAll()
lgui.main()
