#! /usr/bin/env lua

require("lgui")

local window = lgui.Window.new()
local view	 = lgui.TreeView.new()
local model	 = lgui.TreeStore.new("gchararray")
local col1	 = lgui.TreeViewColumn.new("Languages", lgui.CellRendererText.new(), "text", 0, false)
local iter	 = lgui.TreeIter.new()
local dad    = lgui.TreeIter.new()
local selection = view:getSelection()

function selectionChanged()
	local res, m = selection:getSelected(iter)

	if res then
		print(lgui.TreeModel.get(m, iter, 0))
	end
end

-- Top level
model:append(iter, nil)
model:set(iter, 0, "Low-level")
model:append(iter, nil)
model:set(iter, 0, "High-level")

-- Low level Children
lgui.TreeModel.getIterFromString(model, dad, "0")
model:append(iter, dad)
model:set(iter, 0, "C")
model:append(iter, dad)
model:set(iter, 0, "C++")

-- High level Children
lgui.TreeModel.getIterFromString(model, dad, "1")
model:append(iter, dad)
model:set(iter, 0, "Lua")
model:append(iter, dad)
model:set(iter, 0, "Java")
model:append(iter, dad)
model:set(iter, 0, "Haskell")

view:appendColumn(col1)
view:set("model", model)

selection:setMode(lgui.SELECTION_SINGLE)
selection:connect("changed", selectionChanged)

window:add(view)
window:set("window-position", lgui.WIN_POS_CENTER, "title", "TreeView demo",
	"resizable", false)
window:connect("delete-event", lgui.quit)
window:showAll()

lgui.main()
