#! /usr/bin/env lua

--[[
	Tooltip example.
--]]

require("lgui")

function onTooltip(data, x, y, key, tool)
	tool:cast(lgui.Tooltip)
	tool:setMarkup("<b>Hello World!</b> (nice)")
	tool:setIconFromStock("gtk-about", lgui.ICON_SIZE_BUTTON)
	
	return true
end

local window = lgui.Window.new()
local button = lgui.Button.newWithMnemonic("This button have a tooltip!")
button:set("has-tooltip", true)
button:connect("query-tooltip", onTooltip)

window:add(button)
window:set("title", "Hello Tooltip", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
