#! /usr/bin/env lua

-- TextView example

require("lgui")

local window 	= lgui.Window.new()
local hbox	 	= lgui.HBox.new(false, 5)
local vbox 		= lgui.VBox.new(true, 5)
local sw		= lgui.ScrolledWindow.new()
local view		= lgui.TextView.new()
local buffer 	= view:get("buffer"):cast(lgui.TextBuffer)
local b1, b2, b3 = lgui.Button.newWithMnemonic("Insert _Text"),
lgui.Button.newWithMnemonic("Insert _Pixbuf"), lgui.Button.newWithMnemonic("Insert _With Tags")
local iter		= lgui.TextIter.new()
local buf		= lgui.Pixbuf.newFromFile("icon.png")

local tag1, tag2 = buffer:createTag("MyTag1"), buffer:createTag("MyTag2")

tag1:set("foreground", "red")
tag2:set("font", "Sans Bold", "size", 20 * lgui.PANGO_SCALE)

function insertText()
	buffer:getEndIter(iter)
	buffer:insert(iter, "Hello World!\n")
end

function insertPixbuf()
	buffer:getEndIter(iter)
	buffer:insertPixbuf(iter, buf)
end

function insertTags()
	buffer:getEndIter(iter)
	buffer:insertWithTags(iter, "Hello With Tags!\n", -1, tag1, tag2)
end

sw:add(view)
hbox:packStart(true, true, 0, sw)
hbox:packStart(false, false, 0, vbox)
vbox:packStart(true, true, 0, b1, b2, b3)
window:add(hbox)

window:set("title", "Hello TextView", "window-position", lgui.WIN_POS_CENTER,
"width-request", 500, "height-request", 320)

b1:connect("clicked", insertText)
b2:connect("clicked", insertPixbuf)
b3:connect("clicked", insertTags)

window:connect("delete-event", lgui.quit)
window:showAll()

lgui.main()
