#! /usr/bin/env lua

-- Scale widgets

-- Importing the library
require("lgui")

-- Create the widgets
local window = lgui.Window.new()
local scale1 = lgui.HScale.newWithRange(1, 100, 10)
local adjust = lgui.Adjustment.new(1, 1, 100, 2, 10, 0)
local scale2 = lgui.HScale.new(adjust)
local vbox   = lgui.VBox.new(true, 5)

vbox:add(scale1, scale2)
window:add(vbox)

-- Syntactic sugar for setting more than one property
window:set("title", "Hello World", "window-position", lgui.WIN_POS_CENTER)
window:set("width-request", 200)

-- Connect the callback
window:connect("delete-event", lgui.quit)

-- Show 'window' and all the widgets in 'window'
window:showAll()

-- Start the main loop
lgui.main()
