#! /usr/bin/env lua

-- RecentDialog demo

require("lgui")

function runDialog(dialog)
	dialog:run()
	dialog:hide()

	local t = lgui.RecentChooser.getCurrentItem(dialog)
	if t then print(t, t:lastApplication(), t:getURI()) end
end

local window = lgui.Window.new()
local button = lgui.Button.newWithMnemonic("_Show Dialog")
local dialog = lgui.RecentChooserDialog.new("Recent files", window,	"gtk-cancel",
	lgui.RESPONSE_CANCEL, "gtk-ok", lgui.RESPONSE_OK)

window:connect("delete-event", lgui.quit)
button:connect("clicked", runDialog, dialog)

window:set("title", "RecentDialog demo", "window-position", lgui.WIN_POS_CENTER)
window:add(button)
window:showAll()

lgui.main()
