#! /usr/bin/env lua

--[[
	"Internal" drag-n-drop example.
--]]

require("lgui")

local window 	= lgui.Window.new()
local vbox   	= lgui.VBox.new(true, 10)
local button1 	= lgui.Button.newWithMnemonic("Source 1")
local button2  	= lgui.Button.newWithMnemonic("Source 2")
local label  	= lgui.Label.new("Destination - Drag here")

function motion(data, context, x, y, time)
	lgui.DragContext.status(context, lgui.ACTION_COPY, time)
	return true
end

function drop(data, context, x, y, time)
	local text		= "External source"
	local widget	= lgui.DragContext.getSourceWidget(context)

	if widget then text = widget:get("label")  end

	label:set("label", text)
	lgui.DragContext.finish(context, true, false, time)

	return true
end

vbox:add(button1, button2, label)
window:add(vbox)

lgui.DragSource.set(button1, lgui.BUTTON1_MASK)
lgui.DragSource.set(button2, lgui.BUTTON1_MASK)
lgui.DragDest.set(label, 0)

lgui.DragSource.setIconStock(button1, "gtk-remove")
lgui.DragSource.setIconStock(button2, "gtk-add")

label:connect("drag-motion", motion)
label:connect("drag-drop", drop)
label:connect("drag-data-received", function(a,b,c,d) print(a,b,c,d) end)

window:set("title", "DnD", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)
window:showAll()

lgui.main()
