#! /usr/bin/env lua

-- ComboBoxEntry

require("lgui")

local window = lgui.Window.new()
local model  = lgui.ListStore.new("gchararray")
local iter	 = lgui.TreeIter.new()
local combo  = lgui.ComboBoxEntry.newWithModel(model, 0)
local entry	 = combo:getChildren()[1]

local data = {
	"Into the distance", "learning to fly", "misfit", "progressive"
}

for i, j in ipairs(data) do
	model:append(iter)
	model:seto(iter, j)
end

---
-- Set the iter when a item is selected.
-- This is called also when the user types, but getActiveIter will not
-- set the iter if it was an edition.
function selected()
	combo:getActiveIter(iter)
end

---
-- When the user confirms the edition (return).
function editModel()
	model:set(iter, 0, entry:get("text"))
end

entry:connect("changed", selected)
entry:connect("activate", editModel)

window:add(combo)
window:set("title", "Hello ComboBoxEntry", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
