#! /usr/bin/env lua

-- Advanced ComboBox

require("lgui")

local window = lgui.Window.new()
local model  = lgui.ListStore.new("gchararray", "gboolean")
local iter	 = lgui.TreeIter.new()
local combo  = lgui.ComboBox.newWithModel(model)
local r1, r2 = lgui.CellRendererPixbuf.new(), lgui.CellRendererText.new()

local data = {
	"gtk-ok", "gtk-about", "gtk-info", "gtk-cut", "gtk-help"
}

for i, j in ipairs(data) do
	model:append(iter)
	model:seto(iter, j, i % 2 == 1)
end

lgui.CellLayout.packStart(combo, r1, false);
lgui.CellLayout.packStart(combo, r2, false);

lgui.CellLayout.addAttribute(combo, r1, "stock-id", 0, "sensitive", 1)
lgui.CellLayout.addAttribute(combo, r2, "text", 0, "sensitive", 1)

combo:set("active", 0)

window:add(combo)
window:set("title", "Hello ComboBox", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
