#! /usr/bin/env lua

-- Bows & Arrows

require("lgui")

local window = lgui.Window.new()
local box = lgui.HBox.new(true, 5)

function buildArrow(...)
	for i, dir in pairs({...}) do
		local button = lgui.Button.new()
		button:add(lgui.Arrow.new(dir, lgui.SHADOW_IN))
		box:add(button)
		button:connect("clicked", function() print("Dir: ", dir) end)
	end
end

buildArrow(lgui.ARROW_LEFT, lgui.ARROW_UP, lgui.ARROW_RIGHT, lgui.ARROW_DOWN)

window:add(box)	
window:set("title", "Arrows!", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
