<?php

	/*
	*
	* The Sugar Quill's Flourish and Blotts Fan Fiction Archive
	* fflag source file
	*
	* Written by: aerischan
	* based on ffnet.source.php written by: erayd
	*
	*/

function squill_source_info() {
	return "\tFetches stories from www.sugarquill.net";
}

function squill_get_story($storyid) {
	$ffurl = 'www.sugarquill.net';
	$story['source'] = $ffurl;
	$ffurl = 'http://' . $ffurl;

	//get initial info
	printMsg("\t* Fetching story info from {$ffurl}...\n");
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_USERAGENT, 'FLAG/1.0 (Fanfiction.net Lightweight Automated Grabber)');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_URL, "$ffurl/read.php?storyid=$storyid&chapno=1");
	$story['pages'][1] = curl_exec($ch);

	$s = str_replace("\r\n", "\n", $story['pages'][1]);
	$s = str_replace("\t", "", $s);
	$s = str_replace("\n<option value=\"", "<option  value=\"", $s);
	$s = str_replace("</option>", "", $s);

	//extract metadata
	$story['meta'] = squill_get_meta($s);
	printMsg("\t   Title:\t{$story['meta']['title']}\n");
	printMsg("\t   Author:\t{$story['meta']['author']}\n");
	/*printMsg("\t   Category:\t{$story['meta']['category']}\n");
	printMsg("\t   Genre:\t{$story['meta']['genre']}\n");
	printMsg("\n\t   Published:\t{$story['meta']['date_pub']}\tLanguage: {$story['meta']['language']}\n");
	printMsg("\t   Last Update:\t{$story['meta']['date_update']}\tRating:   {$story['meta']['rating']}\n");
	if(!$story['meta']['complete']) printMsg("\t   [!] This story is incomplete!\n");
	printMsg("\t   Summary:\t{$story['meta']['summary']}\n");*/

	//fetch remaining pages
	if(isset($story['meta']['chapters'])) {
		foreach($story['meta']['chapters'] as $key => $chaptitle) {
			if(!isset($story['pages'][$key])) {
				if(!$notified) $notified = printMsg("\t* Fetching additional chapters...\n");
				printMsg(sprintf("\t   %2s. %s\n", $key, $chaptitle));
				curl_setopt($ch, CURLOPT_URL, "$ffurl/read.php?storyid=$storyid&chapno=$key");
				$story['pages'][$key] = curl_exec($ch);
			}
		}
	}
	else $story['meta']['chapters'][1] = $story['meta']['title'];

	//clean pages
	printMsg("\t* Extracting content...\n");
	foreach($story['pages'] as &$currpage) {
		$currpage = str_replace("\t", "", $currpage);
		$currpage = str_replace("\r\n", "\n", $currpage);
		$currpage = str_replace("<td class=\"content_pane\">", "<!-- start story -->", $currpage);
		$currpage = str_replace("</div>\n</td>\n\n</tr>", "</div>\n<!-- end story -->\n</tr>", $currpage);
		preg_match("/<!-- start story -->(.+)<!-- end story -->/Usi", $currpage, $matches);
		$currpage = $matches[1];
		$currpage = str_replace("\x93", "\x22", $currpage);
		$currpage = str_replace("\x94", "\x22", $currpage);
		$currpage = str_replace("\x91", "\x27", $currpage);
		$currpage = str_replace("\x92", "\x27", $currpage);
		$currpage = strip_tags($currpage, '<p><div>');
	}

	return $story;
}

function squill_get_meta($page) {
	$matches = array();

	//title and author
	preg_match("/<td class=\"info2_pane\"><div align=\"right\"><b>Author<\/b>: <a href=\"index.php.+\">(.+)<\/a>&nbsp;&nbsp;<b>Story<\/b>: (.+)&nbsp;&nbsp;<b>Chapter<\/b>:/Ui", $page, $matches);
	$meta['author'] = $matches[1];
	$meta['title'] = $matches[2];

	//miscellaneous
	//preg_match("/<TR><TD><a href='http:\/\/www.fictionratings.com\/guide.php' target='rating'>Fiction Rated: (.+)<\/a> - (.+) - +(.+) - Reviews: <a href='.+'>[0-9]+<\/a> - Published: ([0-9-]+) - Updated: ([0-9-]+) (- (Complete)+ )?- id:[0-9]+ <\/td><\/TD><\/TR>/Ui", $page, $matches);
	$meta['category'] = '';
	$meta['rating'] = '';
	$meta['language'] = '';
	$meta['genre'] = '';
	$meta['date_pub'] = '';
	$meta['date_update'] = '';
	$meta['complete'] = '';
	$meta['ficstatus'] = '';
	$meta['summary'] = '';

	//chapters
	if(preg_match("/<input type=\"hidden\" name=\"storyid\" value=\"[0-9]+\">\n<select name=\"chapno\" size=\"1\">(<option.+)<\/select>/Usi", $page, $matches)) {
		preg_match_all("/<option  value=\"([0-9]+)\"( selected)?>(.+)(?=<option|$)/Ui", $matches[1], $matches);
		foreach($matches[1] as $key => $chapnum) $chaparr[$chapnum] = $matches[3][$key];
		$meta['chapters'] = $chaparr;
	}

	return $meta;
}

?>