<?php

function ffnet_source_info() {
	return "\tFetches stories from fanfiction.net";
}

function ffnet_get_story($storyid) {
	$ffurl = 'www.fanfiction.net';
	$story['source'] = $ffurl;
	$ffurl = 'http://' . $ffurl;

	//get initial info
	printMsg("\t* Fetching story info from {$ffurl}...\n");
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_USERAGENT, 'FLAG/1.0 (Fanfiction.net Lightweight Automated Grabber)');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
	curl_setopt($ch, CURLOPT_URL, "$ffurl/s/$storyid/1");
	$story['pages'][1] = curl_exec($ch);

	//extract metadata
	$story['meta'] = ffnet_get_meta($story['pages'][1]);
	printMsg("\t   Title:\t{$story['meta']['title']}\n");
	printMsg("\t   Author:\t{$story['meta']['author']}\n");
	printMsg("\t   Category:\t{$story['meta']['category']}\n");
	printMsg("\t   Genre:\t{$story['meta']['genre']}\n");
	printMsg("\n\t   Published:\t{$story['meta']['date_pub']}\tLanguage: {$story['meta']['language']}\n");
	printMsg("\t   Last Update:\t{$story['meta']['date_update']}\tRating:   {$story['meta']['rating']}\n");
	if(!$story['meta']['complete']) printMsg("\t   [!] This story is incomplete!\n");
	printMsg("\t   Summary:\t{$story['meta']['summary']}\n");

	//fetch remaining pages
	if(isset($story['meta']['chapters'])) {
		foreach($story['meta']['chapters'] as $key => $chaptitle) {
			if(!isset($story['pages'][$key])) {
				if(!$notified) $notified = printMsg("\t* Fetching additional chapters...\n");
				printMsg(sprintf("\t   %2s. %s\n", $key, $chaptitle));
				curl_setopt($ch, CURLOPT_URL, "$ffurl/s/$storyid/$key");
				$story['pages'][$key] = curl_exec($ch);
			}
		}
	}
	else $story['meta']['chapters'][1] = $story['meta']['title'];

	//clean pages
	printMsg("\t* Extracting content...\n");
	foreach($story['pages'] as &$currpage) {
		preg_match("/<!-- start story -->(.+)<!-- end story -->/Usi", $currpage, $matches);
		$currpage = $matches[1];
	}

	return $story;
}

function ffnet_get_meta($page) {
	$matches = array();

	//category and title
	preg_match('/<td><a href=.+<\/a> &#187; <a href=.+>(.+)<\/a> &#187; <b>(.+)<\/b><\/td>/Ui', $page, $matches);
	$meta['category'] = $matches[1];
	$meta['title'] = $matches[2];

	//author
	preg_match("/<td>Author: <a href='\/u\/[0-9]+\/.+'>(.+)<\/a><\/td>/Ui", $page, $matches);
	$meta['author'] = $matches[1];

	//rating, lang, category
	preg_match("/<TR><TD><a href='http:\/\/www.fictionratings.com\/guide.php' target='rating'>Fiction Rated: (.+)<\/a> - (.+) - +(.+) - Reviews: <a href='.+'>[0-9]+<\/a> - Published: ([0-9-]+) - Updated: ([0-9-]+) (- (Complete)+ )?- id:[0-9]+ <\/td><\/TD><\/TR>/Ui", $page, $matches);
	$meta['rating'] = $matches[1];
	$meta['language'] = $matches[2];
	$meta['genre'] = $matches[3];
	$meta['date_pub'] = $matches[4];
	$meta['date_update'] = $matches[5];
	$meta['complete'] = $matches[7] == 'Complete' ? true : false;
	$meta['ficstatus'] = $matches[7] == 'Complete' ? 'Complete' : 'In-Progress';

	//description
	preg_match('/<meta name="description" content="(.+), (.+),  (.+)">/Ui', $page, $matches);
	$meta['category2'] = $matches[1];
	$meta['genre2'] = $matches[2];
	$meta['summary'] = $matches[3];
	$meta['summary'] = iconv('UTF-8', 'ISO-8859-15//TRANSLIT//IGNORE', $meta['summary']);

	//chapters
	if(preg_match("/<SELECT title='chapter navigation' Name=chapter onChange=\".+\">(<option.+)<\/select>/Ui", $page, $matches)) {
		preg_match_all("/<option  value=[0-9]+ (selected)?>([0-9]+). (.+)(?=<option|$)/Ui", $matches[1], $matches);
		foreach($matches[2] as $key => $chapnum) $chaparr[$chapnum] = $matches[3][$key];
		$meta['chapters'] = $chaparr;
	}

	return $meta;
}

?>