﻿class AdvancedUserRecipe1234529365(BasicNewsRecipe):
    title          = u'Manager Online'
    oldest_article = 7
    max_articles_per_feed = 100
    encoding              = 'cp874'
    no_stylesheets        = True
    use_embedded_content  = False
    remove_javascript     = True

    remove_tags     = [dict(name='td', attrs={'align':'right'})]
    remove_tags     = [dict(name='td', attrs={'align':'left'})]

    html2lrf_options = ['--ignore-tables']
    html2epub_options = 'linearize_tables = True'

    feeds          = [
                           (u'การเมือง', u'http://www.manager.co.th/RSS/Politics/Politics.xml'),
                           (u'กีฬา', u'http://www.manager.co.th/RSS/Sport/Sport.xml'),
                           (u'อาชญากรรมและกระบวนการยุติธรรม', u'http://www.manager.co.th/RSS/Crime/Crime.xml'),
                           (u'ภูมิภาค', u'http://www.manager.co.th/RSS/Local/Local.xml'),
                           (u'คุณภาพชีวิต', u'http://www.manager.co.th/RSS/QOL/QOL.xml'),
                           (u'เศรษฐกิจ', u'http://www.manager.co.th/RSS/Business/Business.xml'),
                           (u'เกม', u'http://www.manager.co.th/RSS/Game/Game.xml'),
                           (u'วิทยาศาสตร์', u'http://www.manager.co.th/RSS/Science/Science.xml'),
                           (u'ชีวิตในเมือง', u'http://www.manager.co.th/RSS/Metrolife/Metrolife.xml'),
                           (u'ครอบครัว', u'http://www.manager.co.th/RSS/Family/Family.xml'),
                           (u'ชีวิตในรั้วมหาลัย', u'http://www.manager.co.th/RSS/Campus/Campus.xml'),
                           (u'บังเทิง', u'http://www.manager.co.th/RSS/Entertainment/Entertainment.xml'),
                           (u'ผู้จัดกวน', u'http://manager.co.th/rss/getRSS.aspx?browsenewsid=1052'),
                           (u'ธรรมะ - ผู้จัดการ', u'http://manager.co.th/rss/getRSS.aspx?browsenewsid=8101&sourcenewsid=0'),
                           (u'ธรรมะ - ทั่วไป', u'http://manager.co.th/rss/getRSS.aspx?browsenewsid=8100&sourcenewsid=0')
                      ]

    def print_version(self, url):
        return url.replace('http://www.manager.co.th/asp-bin/mgrview.aspx?', 'http://www.manager.co.th/asp-bin/PrintNews.aspx?')