#cs ----------------------------------------------------------------------------
	
	AutoIt Version: 3.2.0.1
	Author:         Bjrn Kaiser
	
	Script Function:
	GUI portion of the iLiad content generator
	
#ce ----------------------------------------------------------------------------

#include-once

#include <GUIConstants.au3>
Opt("GUIOnEventMode", 1)

; == GUI generated with Koda ==
$F_Main = GUICreate("Comic2iLIad", 335, 311)
GUISetOnEvent($GUI_EVENT_CLOSE, "_c2i_gui_closed")

$I_Title = GUICtrlCreateInput("", 16, 24, 297, 24, -1, $WS_EX_CLIENTEDGE)

$I_Description = GUICtrlCreateInput("", 16, 72, 297, 24, -1, $WS_EX_CLIENTEDGE)

$I_Type = GUICtrlCreateInput("", 16, 120, 297, 24, -1, $WS_EX_CLIENTEDGE)

$I_ImageDir = GUICtrlCreateInput("", 16, 168, 265, 24, -1, $WS_EX_CLIENTEDGE)

GUICtrlSetTip(-1, $ln_select_img_dir)

$B_ImageDir = GUICtrlCreateButton("...", 288, 168, 25, 25)
GUICtrlSetOnEvent(-1, "_c2i_b_select_imagedir")
GUICtrlSetTip(-1, $ln_select_img_dir)

$I_TargetDir = GUICtrlCreateInput("", 16, 216, 265, 24, -1, $WS_EX_CLIENTEDGE)
GUICtrlSetTip(-1, $ln_select_tgt_dir)

$B_TargetDir = GUICtrlCreateButton("...", 288, 216, 25, 25)
GUICtrlSetOnEvent(-1, "_c2i_b_select_targetdir")
GUICtrlSetTip(-1, $ln_select_tgt_dir)

$B_Go = GUICtrlCreateButton("&Go !", 16, 272, 105, 25)
GUICtrlSetOnEvent(-1, "_c2i_b_go")

$B_Exit = GUICtrlCreateButton("&Exit", 208, 272, 105, 25)
GUICtrlSetOnEvent(-1, "_c2i_b_exit")

GUICtrlCreateLabel($ln_description, 16, 48, 100, 20)
GUICtrlCreateLabel($ln_img_dir, 16, 144, 100, 20)
GUICtrlCreateLabel($ln_tgt_dir, 16, 192, 100, 20)
GUICtrlCreateLabel($ln_title, 16, 0, 100, 20)
GUICtrlCreateLabel($ln_type, 16, 96, 100, 20)
GUISetState(@SW_SHOW)

While 1
	Sleep(1000)
WEnd

Func _c2i_gui_closed()
	Exit
EndFunc   ;==>_c2i_gui_closed

Func _c2i_b_exit()
	Exit
EndFunc   ;==>_c2i_b_exit

Func _c2i_b_go()
	$title = GUICtrlRead($I_Title)
	$description = GUICtrlRead($I_Description)
	$image_dir = GUICtrlRead($I_ImageDir)
	$target_dir = GUICtrlRead($I_TargetDir)
	$type = GUICtrlRead($I_Type)
	_c2i_main ($image_dir, $target_dir, $title, $description, $type)
EndFunc   ;==>_c2i_b_go

Func _c2i_b_select_targetdir()
	$target_dir = FileSelectFolder($ln_select_tgt_dir, "", 5)
	GUICtrlSetData($I_TargetDir, $target_dir)
	$target_dir = GUICtrlRead($I_TargetDir)
EndFunc   ;==>_c2i_b_select_targetdir

Func _c2i_b_select_imagedir()
	$image_dir = FileSelectFolder($ln_select_img_dir, "", 5)
	GUICtrlSetData($I_ImageDir, $image_dir)
	$image_dir = GUICtrlRead($I_ImageDir)
EndFunc   ;==>_c2i_b_select_imagedir