#cs ----------------------------------------------------------------------------
	
	AutoIt Version: 3.2.0.1.0.3
	Author:         Bjrn Kaiser
	
	Script Function:
	Generates HTML-files and manifest.xml for the iRex iLiad e-reader from
	comic pictures
	
#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include "language.au3"
#include "gui.au3"

Func _c2i_main($img_dir = 0, $target_dir = 0, $title = 0, $description = 0, $type = 0)
	If $target_dir <> "" Then
		$manifest = FileOpen($target_dir & "\manifest.xml", 2)
		If $manifest = -1 Then
			MsgBox(0, $ln_error, $ln_error_fileopen & @LF & $target_dir & "\manifest.xml")
			Exit
		EndIf
		
		$target_dir_img = $target_dir & "\img"
		If FileExists($target_dir_img) = 0 Then DirCreate($target_dir_img)
		If $img_dir <> "" Then
			FileCopy($img_dir & "\*.jpg", $target_dir_img & "\*.*", 1)
			FileCopy($img_dir & "\*.jpeg", $target_dir_img & "\*.*", 1)
			FileCopy($img_dir & "\*.png", $target_dir_img & "\*.*", 1)
			FileCopy($img_dir & "\*.gif", $target_dir_img & "\*.*", 1)
		Else
			$img_dir = $target_dir_img
		EndIf
	EndIf
	
	$s_images = _c2i_get_images($img_dir)
	$a_images = _c2i_split_images($s_images)
	
	$target_dir_img_sub = "./img/"
	
	ProgressOn($ln_progress, $ln_creating_html)
	For $i = 1 To $a_images[0]
		ProgressSet($i / $a_images[0] * 100, $ln_file & $i & $ln_of & $a_images[0])
		$htmlpage = "page" & $i & ".html"
		Select
			Case $i = 1
				_c2i_write_manifest($manifest, $i, $htmlpage, 1, $type, $a_images[0], $title, $description)
				_c2i_write_html($target_dir, $target_dir_img_sub, $i, $a_images[$i], $title, $type, $a_images[0], 1)
			Case $i = $a_images[0]
				_c2i_write_manifest($manifest, $i, $htmlpage, 2)
				_c2i_write_html($target_dir, $target_dir_img_sub, $i, $a_images[$i], $title, $type, "1", 2)
				ProgressOff()
				MsgBox(0, $ln_fin, $i & $ln_fin_proc & @LF & $ln_manifest_utf)
			Case Else
				_c2i_write_manifest($manifest, $i, $htmlpage)
				_c2i_write_html($target_dir, $target_dir_img_sub, $i, $a_images[$i], $title, $type)
		EndSelect
	Next
	FileClose($manifest)
EndFunc   ;==>_c2i_main

Func _c2i_get_images($dir)
	Local $search, $files
	Local $idx_file = $dir & "\imgs.txt"
	
	;check for a image index file
	If FileExists($idx_file) Then
		$file = FileOpen($idx_file, 0)

		; Check if file opened for reading OK
		If $file = -1 Then
			MsgBox(0, "Error", "Unable to open file.")
			Exit
		EndIf

		; Read in lines of text until the EOF is reached
		While 1
			$line = FileReadLine($file)
			If @error = -1 Then ExitLoop
			If $files = "" Then
				$files = $line
			Else
				$files = $files & ";" & $line
			EndIf
		WEnd

		FileClose($file)
	Else
		$search = FileFindFirstFile($dir & "\*.*")
		
		; Check if the search was successful
		If $search = -1 Then
			MsgBox(0, $ln_error, $ln_error_nofiles)
			Exit
		EndIf
		
		While 1
			$file = FileFindNextFile($search)
			If @error Then ExitLoop
			If $file <> "." And $file <> ".." Then
				If $files = "" Then
					$files = $file
				Else
					$files = $files & ";" & $file
				EndIf
			EndIf
		WEnd
		; Close the search handle
		FileClose($search)
	EndIf
	Return $files
EndFunc   ;==>_c2i_get_images

Func _c2i_split_images($s_images)
	$a_images = StringSplit($s_images, ";")
	If @error = 0 Then
		Return $a_images
	Else
		Exit
	EndIf
EndFunc   ;==>_c2i_split_images

;Let us generate some HTML pages (for the time being we don't care fo W3C compliance)
Func _c2i_write_html($target_dir, $img_dir, $i, $img, $title, $type, $page = 0, $flag = 0)
	Local $html = FileOpen($target_dir & "\" & "page" & $i & ".html", 2)
	If $html = -1 Then
		MsgBox(0, $ln_error, $ln_error_fileopen)
		Exit
	EndIf
	FileWrite($html, '<html>' & @LF & '  <head>' & @LF)
	Select
		Case $flag = 1
			$prev_url = "page" & $page & ".html"
			$next_url = "page" & $i + 1 & ".html"
		Case $flag = 2
			$prev_url = "page" & $i - 1 & ".html"
			$next_url = "page" & $page & ".html"
		Case Else
			$prev_url = "page" & $i - 1 & ".html"
			$next_url = "page" & $i + 1 & ".html"
	EndSelect
	FileWrite($html, '    <link rel="prev" href="' & $prev_url & '"/>' & _
			@LF & '    <link rel="next" href="' & $next_url & '"/>' & _
			@LF & '    <meta name="keywords" type="' & $type & '">' & _
			@LF & '    <title>' & $title & '</title>' & _
			@LF & '  </head>' & @LF & '  <body>' & @LF & '    <center>' & _
			@LF & '      <img src="' & $img_dir & $img & '" alt="Image"/>' & _
			@LF & '    </center>' & @LF & '  </body>' & @LF & '</html>' & @LF)
	FileClose($html)
EndFunc   ;==>_c2i_write_html

; now we write the Index file (manifest.xml)
Func _c2i_write_manifest($manifest, $page, $url, $flag = 0, $type = 0, $pages = 0, $title = 0, $description = 0)
	Select
		Case $flag = 1
			FileWrite($manifest, '<?xml version="1.0" encoding="utf-8"?>' & _
					@LF & '<package>' & @LF & '  <metadata>' & @LF & '    <dc-metadata>' & _
					@LF & '      <Title>' & $title & '</Title>' & _
					@LF & '      <Description>' & $description & '</Description>' & _
					@LF & '      <Date>' & @YEAR & '-' & @MON & '-' & @MDAY & _
					'T' & @HOUR & ':' & @MIN & ':' & @SEC & '</Date>' & _
					@LF & '      <Format/>' & _
					@LF & '      <Identifier/>' & _
					@LF & '      <Language>en-us</Language>' & _
					@LF & '      <Type>' & $type & '</Type>' & _
					@LF & '    </dc-metadata>' & _
					@LF & '    <y-metadata>' & _
					@LF & '      <startpage>' & $url & '</startpage>' & _
					@LF & '      <image/>' & _
					@LF & '      <version>000</version>' & _
					@LF & '    </y-metadata>' & _
					@LF & '  </metadata>' & _
					@LF & '  <index>' & _
					@LF & '    <pagelist type="' & $type & '" count="' & $pages & '">' & _
					@LF & '      <page number="' & $page & '" url="' & $url & '"/>' & @LF)
		Case $flag = 2
			FileWrite($manifest, '      <page number="' & $page & '" url="' & $url & '"/>' & _
					@LF & '    </pagelist>' & @LF & '  </index>' & @LF & '</package>' & @LF)
		Case Else
			FileWrite($manifest, '      <page number="' & $page & '" url="' & $url & '"/>' & @LF)
	EndSelect
EndFunc   ;==>_c2i_write_manifest