#! /usr/bin/env lua

--[[
	TreeModelFilter example. A lovely (and resource hungry) feature.
	To enhance the performance, its a good idea to only refilter when the user
	stops typing (waiting, for example, one second after the last type).
	
	This example shows how GtkEntryCompletion works too.
--]]

require("lgui")

local window = lgui.Window.new()
local entry  = lgui.Entry.new()
local comp	 = lgui.EntryCompletion.new()
local label  = lgui.Label.new("Name:")
local hbox   = lgui.HBox.new(false, 5)
local vbox   = lgui.VBox.new(false, 5)
local view	 = lgui.TreeView.new()
local model	 = lgui.ListStore.new("gchararray", "gboolean")
local col1	 = lgui.TreeViewColumn.new("Name", lgui.CellRendererText.new(), "text", 0, false)
local col2   = lgui.TreeViewColumn.new("Rocks?", lgui.CellRendererToggle.new(), "active", 1, false)
local iter	 = lgui.TreeIter.new()

-- Configure the entry completion
comp:setModel(model)
comp:setTextColumn(0)
entry:setCompletion(comp)

-- The filter callback. Return true to show, false to hide the row.
function filter(data, model, iter)
	local str = lgui.TreeModel.get(model, iter, 0)
	local wanted = entry:get("text")
	return str:find(wanted)
end

-- Append the values to the list
local values = {
	{name = "Banana", flag = false},
	{name = "Green Apple", flag = false},
	{name = "Apple",  flag = true},
	{name = "Apple Pie",  flag = true},
	{name = "Apple aliens", flag = false},
	{name = "Apple insects", flag = false},
	{name = "Data structures", flag = true},
	{name = "Data consumers", flag = false},
	{name = "Linux", flag = true}
}

for i, j in ipairs(values) do
	model:append(iter)
	model:set(iter, 0, j.name, 1, j.flag)
end

local filterModel = lgui.TreeModelFilter.new(model)
filterModel:setVisibleFunction(filter)

-- Do the control
local counter = 0

function search()
	counter = counter + 1
	lobj.Timeout.add(lobj.PRIORITY_DEFAULT, 1000, doSearch)
	return false
end

function doSearch()
	counter = counter - 1
	
	if counter == 0 then
		filterModel:refilter()
	end
end

view:appendColumn(col1, col2)
view:set("model", filterModel)

hbox:add(label, entry)
vbox:packStart(false, false, 0, hbox)
vbox:packStart(true, true, 0, view)

-- When the content of the entry change, refilter the model
entry:connect("changed", search)
window:add(vbox)
window:set("window-position", lgui.WIN_POS_CENTER, "title", "TreeModelFilter demo",
"width-request", 300)
window:connect("delete-event", lgui.quit)
window:showAll()

lgui.main()
