#! /usr/bin/env lua

-- Table for layout management

require("lgui")

local window = lgui.Window.new()
local tbl = lgui.Table.new(4, 2, false)

local l = lgui.Label.new("Entry:")
l:set("xalign", 1)
tbl:attachDefaults(l, 0, 1, 0, 1)
tbl:attachDefaults(lgui.Entry.new(), 1, 2, 0, 1)

local l = lgui.Label.new("SpinButton:")
l:set("xalign", 1)
tbl:attachDefaults(l, 0, 1, 1, 2)
tbl:attachDefaults(lgui.SpinButton.newWithRange(1, 100, 1), 1, 2, 1, 2)

local l = lgui.Label.new("Scale:")
l:set("xalign", 1)
tbl:attachDefaults(l, 0, 1, 2, 3)
tbl:attachDefaults(lgui.HScale.newWithRange(1, 100, 1), 1, 2, 2, 3)

local l = lgui.Label.new("CheckButton:")
l:set("xalign", 1)
tbl:attachDefaults(l, 0, 1, 3, 4)
tbl:attachDefaults(lgui.CheckButton.newWithMnemonic("Option"), 1, 2, 3, 4)

tbl:set("column-spacing", 5)

window:set("title", "Table example", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)
window:add(tbl)
window:showAll()

lgui.main()
