#! /usr/bin/env lua

-- Font / Color dialog selection demo. Plus, somo runtime style changes

require("lgui")

-- Create the widgets
local window = lgui.Window.new()
local vbox   = lgui.VBox.new(true, 5)
local hbox   = lgui.HBox.new(true, 5)
local label  = lgui.Label.new("This is a sample text! Can the widgets style be changed?")
local bFont  = lgui.Button.newWithMnemonic("Change _Font")
local bColor = lgui.Button.newWithMnemonic("Change _Background")
local bReset = lgui.Button.newWithMnemonic("_Reset")

-- Font dialog
local fontD  = lgui.FontSelectionDialog.new("Font selection")
local fontS  = fontD:getChooser()

-- Color dialog
local colorD = lgui.ColorSelectionDialog.new("Color selection")
local colorS = colorD:getChooser()

-- Select font callback
function selectFont()
	local res = fontD:run()
	fontD:hide()	
	
	if res == lgui.RESPONSE_OK then
		local desc = fontS:get("font-name")	
		label:modifyFont(lgui.PangoFontDescription.newFromString(desc))
	end
end

-- Select background callback
function selectBackground()
	local res = colorD:run()
	colorD:hide()
	
	if res == lgui.RESPONSE_OK then
		local color = colorS:get("current-color")
		window:modifyBg(lgui.STATE_NORMAL, color)
	end
end

-- Reset callback
function reset()
	label:modifyFont()
	window:modifyBg(lgui.STATE_NORMAL)
	window:resize(1, 1)
end

-- Connect the callbacks
bFont:connect("clicked", selectFont)
bColor:connect("clicked", selectBackground)
bReset:connect("clicked", reset)
window:connect("delete-event", lgui.quit)

-- Add the widgets
hbox:add(bFont, bColor, bReset)
vbox:add(label, hbox)
window:add(vbox)

-- Configure and show the window
window:set("title", "Style demo", "window-position", lgui.WIN_POS_CENTER)
window:showAll()

lgui.main()
