#! /usr/bin/env lua

-- StatusIcon example

require("lgui")

local window 	= lgui.Window.new()
local label 	= lgui.Label.new("Hello StatusIcon!")
local status 	= lgui.StatusIcon.new()
local menu		= lgui.Menu.new()
local i1, i2 	= lgui.ImageMenuItem.newFromStock("gtk-open"), lgui.ImageMenuItem.newFromStock("gtk-quit")
local visible	= false

menu:add(i1, i2)
menu:showAll()

function showHide()
	visible = not visible
	window:set("visible", visible)
end

function popup()
	menu:popupFromStatusIcon(status)
end

label:show()
window:add(label)
window:set("title", "Hello StatusIcon", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

-- As any GTK application, using stock icons eats some memory
status:set("icon-name", "gtk-about", "visible", true)

i1:connect("activate", showHide)
i2:connect("activate", lgui.quit)
status:connect("activate", showHide)
status:connect("popup-menu", popup)

lgui.main()
