#! /usr/bin/env lua

-- Screen - Some information about the current screen

require("lgui")

local window = lgui.Window.new()
local tble = lgui.Table.new(4, 1, false)
local screen = lgui.Screen.getDefault()
local pos = 0

function addInfo(desc, info)
	local desc = lgui.Label.new(desc)
	local info = lgui.Label.new(tostring(info))
	tble:attachDefaults(desc, 0, 1, pos, pos + 1)	
	tble:attachDefaults(info, 1, 2, pos, pos + 1)	
	pos = pos + 1
end

addInfo("Number:", screen:getNumber())
addInfo("Monitors:", screen:getNMonitors())
addInfo("Size:", string.format("%i x %i", screen:getSize()))
addInfo("Composited:", screen:isComposited())

window:add(tble)	
window:set("title", "Screen info!", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
