#! /usr/bin/env lua

-- Printing example. Uses ldraw!

require("lgui")
require("ldraw")

-- Create the widgets
local window = lgui.Window.new()
local button = lgui.Button.newWithMnemonic("Print test")

function beginPrint(ud, context)
	local operation, data = unpack(ud)
	local width, height = lgui.PrintContext.getSize(context)

	-- Read the file
	file = io.open(data.fileName)
	data.lineCount = 0
	data.text = {}

	-- Read the file and get the line count
	while true do
		local line = file:read("*line")
		if not line then break end

		data.lineCount = data.lineCount + 1
		data.text[data.lineCount] = line
	end

	-- Calculate the number of pages
	data.linesPerPage = math.floor(height / data.fontSize)
	data.pageCount = math.ceil(data.lineCount / data.linesPerPage)

	operation:set("n-pages", data.pageCount)
end

function drawPage(ud, context, page)
	local operation, operation = unpack(ud)

	local cr = ldraw.Context.getFromPrintContext(context)
	local width, height = lgui.PrintContext.getSize(context)

	local layout = lgui.PrintContext.createPangoLayout(context)
	local desc = lgui.PangoFontDescription.newFromString("mono  " .. data.fontSize)
	layout:setFontDescription(desc)

	-- Draw!
	cr:moveTo(0, 20)
	cr:setSourceRgb(0, 0, 1)
	local line = ((data.linesPerPage + 1) * page) + 1

	for i = 0, data.linesPerPage do
		if line > data.lineCount then break end

		layout:setText(data.text[line])
		cr:pangoShowLayout(layout)
		cr:relMoveTo(0, data.fontSize)
		line = line + 1
	end
end

function printTest()
	local op = lgui.PrintOperation.new()

	-- Some info for the printing
	data = {
		fileName = "Printing.lua",
		fontSize = 12
	}

	op:connect("draw-page", drawPage, {op, data})
	op:connect("begin-print", beginPrint, {op, data})
	op:run(lgui.PRINT_OPERATION_ACTION_PRINT_DIALOG, window)
end

window:add(button)
window:set("title", "Print test", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)
button:connect("clicked", printTest)

window:showAll()
lgui.main()
