#! /usr/bin/env lua

-- IconView

require("lgui")

local window = lgui.Window.new()
local model = lgui.ListStore.new("gchararray", "gchararray", "GdkPixbuf")
local buf = lgui.Pixbuf.newFromFile("icon.png")
local iter = lgui.TreeIter.new()

function selected(data, path)
	lgui.TreeModel.getIter(model, iter, path)
	print(lgui.TreeModel.get(model, iter, 0))
end

-- Fill the model
for i = 1, 4 do
	model:append(iter)
	model:set(iter, 0, "Item " .. i, 1, "Tooltip " .. i, 2, buf)
end

local view = lgui.IconView.newWithModel(model)
view:set("columns", 2, "reorderable", true)
view:set("text-column", 0, "tooltip-column", 1, "pixbuf-column", 2)
view:connect("item-activated", selected)
window:add(view)

window:set("title", "IconView", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
