#! /usr/bin/env lua

-- Classic Hello World

-- Importing the library
require("lgui")

-- Callback functions
function hello()
	print("Hello World!")
end

-- Create the widgets
local window = lgui.Window.new()
local button = lgui.Button.new()

-- Set some properties
button:set("label", "Click me!")
window:add(button)

-- Syntactic sugar for setting more than one property
window:set("title", "Hello World", "window-position", lgui.WIN_POS_CENTER)

-- Connect the callbacks
window:connect("delete-event", lgui.quit)
button:connect("clicked", hello)

-- Show 'window' and all the widgets in 'window'
window:showAll()

-- Start the main loop
lgui.main()
