#! /usr/bin/env lua

-- HandleBox example

require("lgui")

local window = lgui.Window.new()
local vbox1	 = lgui.VBox.new(false, 5)
local vbox2  = lgui.VBox.new(false, 5)
local handle = lgui.HandleBox.new()
local l1, l2 = lgui.Label.new("Label 1"), lgui.Label.new("Label 2")
local button = lgui.Button.newWithMnemonic("_Exit")
button:connect("clicked", lgui.quit)

vbox1:add(l1, l2)
handle:add(vbox1)
vbox2:add(handle, button)
window:add(vbox2)
window:set("title", "Hello HandleBox", "window-position", lgui.WIN_POS_CENTER,
	"width-request", 200, "height-request", 200)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
